/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.continent;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.cell.Populator;
import com.terraforged.core.world.terrain.Terrain;
import me.dags.noise.func.Interpolation;
import me.dags.noise.util.NoiseUtil;

public class ContinentLerper2
implements Populator {
    private final Populator lower;
    private final Populator upper;
    private final float blendLower;
    private final float blendUpper;
    private final float blendRange;
    private final float midpoint;
    private final float tagThreshold;

    public ContinentLerper2(Populator lower, Populator upper, float min, float max, float split, float tagThreshold) {
        this.lower = lower;
        this.upper = upper;
        this.blendLower = min;
        this.blendUpper = max;
        this.blendRange = this.blendUpper - this.blendLower;
        this.midpoint = this.blendLower + this.blendRange * split;
        this.tagThreshold = tagThreshold;
    }

    @Override
    public void apply(Cell<Terrain> cell, float x, float y) {
        float select = cell.continentEdge;
        if (select < this.blendLower) {
            this.lower.apply(cell, x, y);
            return;
        }
        if (select > this.blendUpper) {
            this.upper.apply(cell, x, y);
            return;
        }
        float alpha = Interpolation.LINEAR.apply((select - this.blendLower) / this.blendRange);
        this.lower.apply(cell, x, y);
        float lowerVal = cell.value;
        Terrain lowerType = (Terrain)cell.tag;
        this.upper.apply(cell, x, y);
        float upperVal = cell.value;
        cell.value = NoiseUtil.lerp(lowerVal, upperVal, alpha);
        if (select < this.midpoint) {
            cell.tag = lowerType;
        }
    }

    @Override
    public void tag(Cell<Terrain> cell, float x, float y) {
        float select = cell.continentEdge;
        if (select < this.blendLower) {
            this.lower.tag(cell, x, y);
            return;
        }
        if (select > this.blendUpper) {
            this.upper.tag(cell, x, y);
            return;
        }
        if (select < this.tagThreshold) {
            this.lower.tag(cell, x, y);
        } else {
            this.upper.tag(cell, x, y);
        }
    }
}

