/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.continent;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.cell.Populator;
import com.terraforged.core.settings.GeneratorSettings;
import com.terraforged.core.util.Seed;
import com.terraforged.core.world.terrain.Terrain;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.domain.Domain;
import me.dags.noise.func.DistanceFunc;
import me.dags.noise.func.EdgeFunc;
import me.dags.noise.util.NoiseUtil;
import me.dags.noise.util.Vec2f;

public class ContinentModule
implements Populator {
    private static final float edgeClampMin = 0.05f;
    private static final float edgeClampMax = 0.5f;
    private static final float edgeClampRange = 0.45f;
    private final int seed;
    private final float frequency;
    private final float edgeMin;
    private final float edgeMax;
    private final float edgeRange;
    private final Domain warp;
    private final Module shape;

    public ContinentModule(Seed seed, GeneratorSettings settings) {
        int tectonicScale = settings.land.continentScale * 4;
        int continentScale = settings.land.continentScale / 2;
        double oceans = Math.min(Math.max((double)settings.world.oceanSize, 0.01), 0.99);
        double shapeMin = 0.15 + oceans * 0.35;
        this.seed = seed.next();
        this.frequency = 1.0f / (float)tectonicScale;
        this.edgeMin = 0.05f;
        this.edgeMax = (float)oceans;
        this.edgeRange = this.edgeMax - this.edgeMin;
        this.warp = Domain.warp(Source.SIMPLEX, seed.next(), continentScale, 3, continentScale);
        this.shape = Source.perlin(seed.next(), settings.land.continentScale, 2).clamp(shapeMin, 0.7).map(0.0, 1.0).warp(Source.SIMPLEX, seed.next(), continentScale / 2, 1, (double)continentScale / 4.0).warp(seed.next(), 50, 1, 20.0);
    }

    @Override
    public float getValue(float x, float y) {
        throw new RuntimeException("no pls!");
    }

    @Override
    public void apply(Cell<Terrain> cell, float x, float y) {
        float ox = this.warp.getOffsetX(x, y);
        float oz = this.warp.getOffsetY(x, y);
        float px = x + ox;
        float py = y + oz;
        int cellX = 0;
        int cellY = 0;
        int xr = NoiseUtil.round(px *= this.frequency);
        int yr = NoiseUtil.round(py *= this.frequency);
        float edgeDistance = 999999.0f;
        float edgeDistance2 = 999999.0f;
        float valueDistance = Float.MAX_VALUE;
        DistanceFunc dist = DistanceFunc.NATURAL;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                int xi = xr + dx;
                int yi = yr + dy;
                Vec2f vec = NoiseUtil.CELL_2D[NoiseUtil.hash2D(this.seed, xi, yi) & 0xFF];
                float vecX = (float)xi - px + vec.x;
                float vecY = (float)yi - py + vec.y;
                float distance = dist.apply(vecX, vecY);
                if (distance < valueDistance) {
                    valueDistance = distance;
                    cellX = xi;
                    cellY = yi;
                }
                edgeDistance2 = distance < edgeDistance2 ? Math.max(edgeDistance, distance) : Math.max(edgeDistance, edgeDistance2);
                edgeDistance = Math.min(edgeDistance, distance);
            }
        }
        float shapeNoise = this.shape.getValue(x, y);
        float continentNoise = this.edgeValue(edgeDistance, edgeDistance2);
        cell.continent = this.cellValue(this.seed, cellX, cellY);
        cell.continentEdge = shapeNoise * continentNoise;
    }

    @Override
    public void tag(Cell<Terrain> cell, float x, float y) {
    }

    private float cellValue(int seed, int cellX, int cellY) {
        float value = NoiseUtil.valCoord2D(seed, cellX, cellY);
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    private float edgeValue(float distance, float distance2) {
        EdgeFunc edge = EdgeFunc.DISTANCE_2_DIV;
        float value = edge.apply(distance, distance2);
        float edgeValue = 1.0f - NoiseUtil.map(value, edge.min(), edge.max(), edge.range());
        if (edgeValue < this.edgeMin) {
            return 0.0f;
        }
        if (edgeValue > this.edgeMax) {
            return 1.0f;
        }
        return (edgeValue - this.edgeMin) / this.edgeRange;
    }
}

