/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.decorator;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.decorator.Decorator;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.Terrains;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.func.CellFunc;

public class DesertDunes
implements Decorator {
    private final Module module;
    private final float climateMin;
    private final float climateMax;
    private final float climateRange;
    private final Levels levels;
    private final Terrains terrains;
    private final Terrain dunes = new Terrain("dunes", 100);

    public DesertDunes(GeneratorContext context) {
        this.climateMin = 0.6f;
        this.climateMax = 0.85f;
        this.climateRange = this.climateMax - this.climateMin;
        this.levels = context.levels;
        this.terrains = context.terrain;
        this.module = Source.cell(context.seed.next(), 80, CellFunc.DISTANCE).warp(context.seed.next(), 70, 1, 70.0).scale(0.11764705882352941);
    }

    @Override
    public boolean apply(Cell<Terrain> cell, float x, float y) {
        float temp = cell.temperature;
        float moisture = 1.0f - cell.moisture;
        float climate = temp * moisture;
        if (climate < this.climateMin) {
            return false;
        }
        float duneHeight = this.module.getValue(x, y);
        float climateMask = climate > this.climateMax ? 1.0f : (climate - this.climateMin) / this.climateRange;
        float regionMask = cell.mask(0.4f, 0.5f, 0.0f, 0.8f);
        float height = duneHeight * climateMask * regionMask;
        cell.value += height;
        cell.tag = this.dunes;
        return height >= this.levels.unit;
    }
}

