/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.decorator;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.util.Seed;
import com.terraforged.core.world.decorator.Decorator;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.Terrains;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.util.NoiseUtil;

public class Wetlands
implements Decorator {
    private final Module module;
    private final float poolBase;
    private final float bankHeight;
    private final Terrain wetlands;

    public Wetlands(Seed seed, Terrains terrain, Levels levels) {
        this.wetlands = terrain.wetlands;
        this.poolBase = levels.water(-3);
        this.bankHeight = levels.water(2);
        this.module = Source.perlin(seed.next(), 12, 1).clamp(0.35, 0.65).map(0.0, 1.0);
    }

    @Override
    public boolean apply(Cell<Terrain> cell, float x, float y) {
        if (cell.value < this.poolBase) {
            return false;
        }
        float tempAlpha = Wetlands.getAlpha(cell.temperature, 0.3f, 0.7f);
        if (tempAlpha == 0.0f) {
            return false;
        }
        float moistAlpha = Wetlands.getAlpha(cell.moisture, 0.7f, 1.0f);
        if (moistAlpha == 0.0f) {
            return false;
        }
        float riverAlpha = Wetlands.getAlpha(1.0f - cell.riverMask, 0.85f, 0.95f);
        if (riverAlpha == 0.0f) {
            return false;
        }
        float alpha = tempAlpha * moistAlpha * riverAlpha;
        float value1 = NoiseUtil.lerp(cell.value, this.bankHeight, alpha);
        cell.value = Math.min(cell.value, value1);
        float poolAlpha = Wetlands.getAlpha(alpha, 0.35f, 0.55f);
        float shape = this.module.getValue(x, y);
        float value2 = NoiseUtil.lerp(cell.value, this.poolBase, shape * poolAlpha);
        cell.value = Math.min(cell.value, value2);
        if ((double)poolAlpha > 0.5) {
            cell.tag = this.wetlands;
        }
        return true;
    }

    private static float getAlpha(float value, float min, float max) {
        return Wetlands.getAlpha(value, min, max, false);
    }

    private static float getAlpha(float value, float min, float max, boolean inverse) {
        if (value < min) {
            return 0.0f;
        }
        if (value >= max) {
            return 1.0f;
        }
        float alpha = (value - min) / (max - min);
        if (inverse) {
            return 1.0f - alpha;
        }
        return alpha;
    }
}

