/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.heightmap;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.WorldDecorators;
import com.terraforged.core.world.WorldGeneratorFactory;
import com.terraforged.core.world.decorator.Decorator;
import com.terraforged.core.world.heightmap.Heightmap;
import com.terraforged.core.world.terrain.Terrain;

public class WorldLookup {
    private final float waterLevel;
    private final float beachLevel;
    private final Heightmap heightmap;
    private final WorldDecorators decorators;
    private final GeneratorContext context;

    public WorldLookup(WorldGeneratorFactory factory, GeneratorContext context) {
        this.context = context;
        this.heightmap = factory.getHeightmap();
        this.decorators = factory.getDecorators();
        this.waterLevel = context.levels.water;
        this.beachLevel = context.levels.water(5);
    }

    public Cell<Terrain> getCell(int x, int z) {
        Cell<Terrain> cell = new Cell<Terrain>();
        this.applyCell(cell, x, z);
        return cell;
    }

    public void applyCell(Cell<Terrain> cell, int x, int z) {
        this.heightmap.apply(cell, x, z);
        if (cell.tag == this.context.terrain.coast && cell.value > this.waterLevel && cell.value <= this.beachLevel) {
            cell.tag = this.context.terrain.beach;
        }
        for (Decorator decorator : this.decorators.getDecorators()) {
            if (decorator.apply(cell, x, z)) break;
        }
    }
}

