/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.terrain;

import com.terraforged.core.cell.Tag;
import com.terraforged.core.settings.GeneratorSettings;
import com.terraforged.core.settings.Settings;
import com.terraforged.core.world.heightmap.Levels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class Terrain
implements Tag {
    private static final AtomicInteger MAX_ID = new AtomicInteger(0);
    private static final Map<String, Terrain> register = Collections.synchronizedMap(new HashMap());
    public static final int ID_START = 10;
    public static final Terrain NONE = new Terrain("none", -1);
    private final String name;
    private final int id;
    private final float weight;

    public Terrain(String name, int id) {
        this(name, id, 1.0);
    }

    public Terrain(String name, int id, double weight) {
        this.name = name;
        this.id = id;
        this.weight = (float)weight;
        register.put(name, this);
        MAX_ID.set(Math.max(MAX_ID.get(), id));
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public float getMax(float noise) {
        return 1.0f;
    }

    public float getWeight() {
        return this.weight;
    }

    public float getHue() {
        return (float)this.id / (float)MAX_ID.get();
    }

    public String toString() {
        return this.getName();
    }

    public static Terrain ocean(final Settings settings) {
        return new Terrain("ocean", 0){
            private final float max;
            {
                super(name, id);
                this.max = new Levels((GeneratorSettings)settings.generator).water;
            }

            @Override
            public float getMax(float noise) {
                return this.max;
            }
        };
    }

    public static Terrain deepOcean(final Settings settings) {
        return new Terrain("deep_ocean", 1){
            private final float max;
            {
                super(name, id);
                this.max = new Levels((GeneratorSettings)settings.generator).water / 2.0f;
            }

            @Override
            public float getMax(float noise) {
                return this.max;
            }
        };
    }

    public static Terrain coast(final Settings settings) {
        return new Terrain("coast", 2){
            private final float max;
            {
                super(name, id);
                this.max = new Levels(settings.generator).ground(1);
            }

            @Override
            public float getMax(float noise) {
                return this.max + noise * 0.003921569f;
            }
        };
    }

    public static Terrain beach(final Settings settings) {
        return new Terrain("beach", 2){
            private final float max;
            {
                super(name, id);
                this.max = new Levels(settings.generator).ground(1);
            }

            @Override
            public float getMax(float noise) {
                return this.max + noise * 0.003921569f;
            }
        };
    }

    public static Terrain lake(Settings settings) {
        return new Terrain("lake", 3);
    }

    public static Terrain river(Settings settings) {
        return new Terrain("river", 3);
    }

    public static Terrain riverBank(Settings settings) {
        return new Terrain("river_banks", 4);
    }

    public static Terrain wetlands(Settings settings) {
        return new Terrain("wetlands", 5);
    }

    public static Terrain steppe(Settings settings) {
        return new Terrain("steppe", 6, settings.terrain.steppe.weight);
    }

    public static Terrain plains(Settings settings) {
        return new Terrain("plains", 7, settings.terrain.plains.weight);
    }

    public static Terrain plateau(Settings settings) {
        return new Terrain("plateau", 8, settings.terrain.plateau.weight);
    }

    public static Terrain badlands(Settings settings) {
        return new Terrain("badlands", 9, settings.terrain.badlands.weight);
    }

    public static Terrain hills(Settings settings) {
        return new Terrain("hills", 10, settings.terrain.hills.weight);
    }

    public static Terrain dales(Settings settings) {
        return new Terrain("dales", 11, settings.terrain.dales.weight);
    }

    public static Terrain torridonian(Settings settings) {
        return new Terrain("torridonian_fells", 12, settings.terrain.torridonian.weight);
    }

    public static Terrain mountains(Settings settings) {
        return new Terrain("mountains", 13, settings.terrain.mountains.weight);
    }

    public static Terrain volcano(Settings settings) {
        return new Terrain("volcano", 14, settings.terrain.volcano.weight);
    }

    public static Terrain volcanoPipe(Settings settings) {
        return new Terrain("volcano_pipe", 15, settings.terrain.volcano.weight);
    }

    public static Optional<Terrain> get(String name) {
        return Optional.ofNullable(register.get(name));
    }

    public static List<Terrain> getRegistered() {
        return new ArrayList<Terrain>(register.values());
    }
}

