/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.matcher.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.terraforged.feature.matcher.feature.Rule;
import com.terraforged.feature.matcher.feature.Search;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FeatureMatcher
implements Predicate<JsonElement> {
    public static final FeatureMatcher ANY = new FeatureMatcher(Collections.emptyList());
    public static final FeatureMatcher NONE = new FeatureMatcher(Collections.emptyList());
    private final List<Rule> rules;

    private FeatureMatcher(List<Rule> rules) {
        this.rules = rules;
    }

    public String toString() {
        return "JsonMatcher{rules=" + this.rules + '}';
    }

    @Override
    public boolean test(JsonElement element) {
        if (this == ANY) {
            return true;
        }
        if (this == NONE) {
            return false;
        }
        return this.test(element, new Search(this.rules));
    }

    private boolean test(JsonElement element, Search search) {
        if (element.isJsonObject()) {
            for (Map.Entry e : element.getAsJsonObject().entrySet()) {
                if (!this.test((JsonElement)e.getValue(), search)) continue;
                return true;
            }
        } else if (element.isJsonArray()) {
            for (JsonElement e : element.getAsJsonArray()) {
                if (!this.test(e, search)) continue;
                return true;
            }
        } else if (element.isJsonPrimitive()) {
            return search.test(element.getAsJsonPrimitive());
        }
        return false;
    }

    public static Optional<FeatureMatcher> of(JsonElement element) {
        List<Rule> rules = Rule.parseRules(element);
        if (rules.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new FeatureMatcher(rules));
    }

    public static FeatureMatcher of(Object arg) {
        return FeatureMatcher.and(arg);
    }

    public static FeatureMatcher or(Object ... args) {
        if (args.length == 0) {
            return ANY;
        }
        Builder builder = FeatureMatcher.builder();
        for (Object o : args) {
            builder.or(o);
        }
        return builder.build();
    }

    public static FeatureMatcher and(Object ... args) {
        if (args.length == 0) {
            return ANY;
        }
        Builder builder = FeatureMatcher.builder();
        for (Object arg : args) {
            builder.and(arg);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static JsonElement arg(Object arg) {
        if (arg instanceof String) {
            return new JsonPrimitive((String)arg);
        }
        if (arg instanceof Number) {
            return new JsonPrimitive((Number)arg);
        }
        if (arg instanceof Boolean) {
            return new JsonPrimitive((Boolean)arg);
        }
        if (arg instanceof ForgeRegistryEntry) {
            return new JsonPrimitive(((ForgeRegistryEntry)arg).getRegistryName() + "");
        }
        return JsonNull.INSTANCE;
    }

    public static class Builder {
        private List<Rule> rules = Collections.emptyList();
        private List<JsonPrimitive> values = Collections.emptyList();

        public Builder and(Object value) {
            JsonElement element = FeatureMatcher.arg(value);
            if (element.isJsonPrimitive()) {
                this.and(element.getAsJsonPrimitive());
            }
            return this;
        }

        public Builder and(Boolean value) {
            return this.and(new JsonPrimitive(value));
        }

        public Builder and(Number value) {
            return this.and(new JsonPrimitive(value));
        }

        public Builder and(String value) {
            return this.and(new JsonPrimitive(value));
        }

        public Builder and(JsonPrimitive value) {
            if (this.values.isEmpty()) {
                this.values = new ArrayList<JsonPrimitive>();
            }
            this.values.add(value);
            return this;
        }

        public Builder or(Object value) {
            JsonElement element = FeatureMatcher.arg(value);
            if (element.isJsonPrimitive()) {
                this.or(element.getAsJsonPrimitive());
            }
            return this;
        }

        public Builder or(Boolean value) {
            return this.or(new JsonPrimitive(value));
        }

        public Builder or(Number value) {
            return this.or(new JsonPrimitive(value));
        }

        public Builder or(String value) {
            return this.or(new JsonPrimitive(value));
        }

        public Builder or(JsonPrimitive value) {
            return this.newRule().and(value);
        }

        public Builder newRule() {
            if (!this.values.isEmpty()) {
                if (this.rules.isEmpty()) {
                    this.rules = new ArrayList<Rule>();
                }
                this.rules.add(new Rule(this.values));
                this.values = Collections.emptyList();
            }
            return this;
        }

        public FeatureMatcher build() {
            if (this.rules.isEmpty() && this.values.isEmpty()) {
                return NONE;
            }
            this.newRule();
            return new FeatureMatcher(this.rules);
        }
    }
}

