/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.template;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.terraforged.feature.template.type.FeatureType;
import com.terraforged.feature.template.type.FeatureTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;

public class TemplateConfig {
    private final String type;
    private final int extendBase;
    private final JsonElement decorators;
    private final ResourceLocation name;
    private final List<ResourceLocation> paths;

    private TemplateConfig(Builder builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.paths = builder.paths;
        this.extendBase = builder.base;
        this.decorators = builder.decorators;
    }

    public FeatureType getType() {
        return FeatureTypes.getType(this.type);
    }

    public int getBaseDepth() {
        return this.extendBase;
    }

    public JsonElement getDecorators() {
        return this.decorators;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Iterable<ResourceLocation> getPaths() {
        return this.paths;
    }

    public static Optional<TemplateConfig> parse(ResourceLocation location, JsonElement element) {
        if (!element.isJsonObject()) {
            return Optional.empty();
        }
        JsonObject root = element.getAsJsonObject();
        if (!root.has("name") || !root.has("paths")) {
            return Optional.empty();
        }
        Builder builder = TemplateConfig.builder();
        builder.name(location.func_110624_b(), root.get("name").getAsString());
        if (root.has("type")) {
            builder.type(root.get("type").getAsString());
        }
        if (root.has("base")) {
            builder.base(root.get("base").getAsInt());
        }
        if (root.has("decorators")) {
            builder.decorators(root.get("decorators"));
        }
        for (JsonElement path : root.getAsJsonArray("paths")) {
            builder.path(location.func_110624_b(), path.getAsString());
        }
        return Optional.of(builder.build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int base;
        private String type;
        private ResourceLocation name;
        private JsonElement decorators = JsonNull.INSTANCE;
        private List<ResourceLocation> paths = new ArrayList<ResourceLocation>();

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder base(int depth) {
            this.base = depth;
            return this;
        }

        public Builder decorators(JsonElement element) {
            this.decorators = element;
            return this;
        }

        public Builder name(String namespace, String name) {
            int split = name.indexOf(58);
            if (split > 0) {
                namespace = name.substring(0, split);
                name = name.substring(split + 1);
            }
            this.name = new ResourceLocation(namespace, name);
            return this;
        }

        public Builder path(String namespace, String location) {
            int split = location.indexOf(58);
            if (split > 0) {
                namespace = location.substring(0, split);
                if (!(location = location.substring(split + 1)).startsWith("structures/")) {
                    location = "structures/" + location;
                }
            }
            this.paths.add(new ResourceLocation(namespace, location));
            return this;
        }

        public TemplateConfig build() {
            return new TemplateConfig(this);
        }
    }
}

