/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.template.decorator;

import com.terraforged.feature.template.decorator.Decorator;
import com.terraforged.feature.template.decorator.DecoratorWorld;
import com.terraforged.feature.template.type.FeatureType;
import com.terraforged.feature.template.type.TypedFeature;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class DecoratedFeature<T extends Feature<NoFeatureConfig>, W extends DecoratorWorld>
extends Feature<NoFeatureConfig>
implements TypedFeature {
    private final T feature;
    private final List<Decorator<W>> decorators;
    private final Function<IWorld, W> worldFactory;

    public DecoratedFeature(T feature, List<Decorator<W>> decorators, Function<IWorld, W> factory) {
        super(NoFeatureConfig::func_214639_a);
        this.worldFactory = factory;
        this.feature = feature;
        this.decorators = decorators;
        this.setRegistryName(feature.getRegistryName());
    }

    public T getFeature() {
        return this.feature;
    }

    public List<Decorator<W>> getDecorators() {
        return this.decorators;
    }

    public W wrap(IWorld world) {
        return (W)((DecoratorWorld)this.worldFactory.apply(world));
    }

    @Override
    public FeatureType getType() {
        return ((TypedFeature)this.feature).getType();
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        DecoratorWorld featureWorld = (DecoratorWorld)this.worldFactory.apply(world);
        if (this.placeFeature(featureWorld, generator, rand, pos, config)) {
            this.decorate(featureWorld, rand);
            return true;
        }
        return false;
    }

    public boolean placeFeature(W world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        return this.feature.func_212245_a(world, generator, rand, pos, (IFeatureConfig)config);
    }

    public void decorate(W world, Random random) {
        for (Decorator<W> decorator : this.decorators) {
            decorator.apply(world, random);
        }
    }
}

