/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.template.decorator.tree;

import com.terraforged.feature.template.decorator.BoundsRecorder;
import com.terraforged.feature.template.decorator.DecoratorWorld;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;

public class TreeBuffer
extends BoundsRecorder
implements DecoratorWorld {
    private Set<BlockPos> logs = null;
    private Set<BlockPos> leaves = null;
    private List<BlockPos> logList = null;
    private List<BlockPos> leafList = null;

    public TreeBuffer(IWorld delegate) {
        super(delegate);
    }

    @Override
    public void setDelegate(IWorld world) {
        super.setDelegate(world);
    }

    @Override
    public boolean func_180501_a(BlockPos pos, BlockState state, int flags) {
        this.recordState(pos, state);
        return super.func_180501_a(pos, state, flags);
    }

    @Override
    public void translate(BlockPos offset) {
        super.translate(offset);
        this.logList = this.getLogPositions().stream().map(pos -> pos.func_177971_a((Vec3i)offset)).sorted(Comparator.comparingInt(Vec3i::func_177956_o)).collect(Collectors.toList());
        this.leafList = this.getLeafPositions().stream().map(pos -> pos.func_177971_a((Vec3i)offset)).sorted(Comparator.comparingInt(Vec3i::func_177956_o)).collect(Collectors.toList());
    }

    public Set<BlockPos> getLogPositions() {
        return this.logs == null ? Collections.emptySet() : this.logs;
    }

    public Set<BlockPos> getLeafPositions() {
        return this.leaves == null ? Collections.emptySet() : this.leaves;
    }

    public List<BlockPos> getLogs() {
        if (this.logList == null) {
            this.logList = this.getLogPositions().stream().sorted(Comparator.comparingInt(Vec3i::func_177956_o)).collect(Collectors.toList());
        }
        return this.logList;
    }

    public List<BlockPos> getLeaves() {
        if (this.leafList == null) {
            this.leafList = this.getLeafPositions().stream().sorted(Comparator.comparingInt(Vec3i::func_177956_o)).collect(Collectors.toList());
        }
        return this.leafList;
    }

    private void recordState(BlockPos pos, BlockState state) {
        if (BlockTags.field_206952_E.func_199685_a_((Object)state.func_177230_c())) {
            this.addLeaves(pos);
            return;
        }
        if (BlockTags.field_200031_h.func_199685_a_((Object)state.func_177230_c())) {
            this.addLog(pos);
        }
    }

    private void addLog(BlockPos pos) {
        if (this.logs == null) {
            this.logs = new HashSet<BlockPos>();
        }
        this.logs.add(pos);
    }

    private void addLeaves(BlockPos pos) {
        if (this.leaves == null) {
            this.leaves = new HashSet<BlockPos>();
        }
        this.leaves.add(pos);
    }
}

