/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.map;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.mod.biome.map.AbstractBiomeMap;
import com.terraforged.mod.biome.map.BiomeMapBuilder;
import com.terraforged.mod.biome.provider.BiomeHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.world.biome.Biome;

public class BasicBiomeMap
extends AbstractBiomeMap {
    private final Biome[][] biomeTypes;

    public BasicBiomeMap(BiomeMapBuilder builder) {
        super(builder);
        this.biomeTypes = builder.biomeList();
    }

    @Override
    public List<Biome> getAllBiomes(BiomeType type) {
        if (type.ordinal() >= this.biomeTypes.length) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.biomeTypes[type.ordinal()]);
    }

    @Override
    public Set<Biome> getBiomes(BiomeType type) {
        if (type.ordinal() >= this.biomeTypes.length) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])this.biomeTypes[type.ordinal()]);
    }

    @Override
    public Biome getBiome(BiomeType type, float temperature, float moisture, float shape) {
        return this.get(this.biomeTypes, type, shape, temperature, this.defaultLand);
    }

    @Override
    public JsonObject toJson() {
        JsonObject groups = new JsonObject();
        for (BiomeType type : BiomeType.values()) {
            JsonArray group = new JsonArray();
            this.getBiomes(type).stream().map(BiomeHelper::getId).sorted().forEach(arg_0 -> ((JsonArray)group).add(arg_0));
            groups.add(type.name(), (JsonElement)group);
        }
        JsonObject root = super.toJson();
        root.add("biomes", (JsonElement)groups);
        return root;
    }
}

