/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.map;

import com.terraforged.core.util.grid.FixedGrid;
import com.terraforged.core.world.biome.BiomeData;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.mod.biome.map.BasicBiomeMap;
import com.terraforged.mod.biome.map.BiomeGroup;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.map.GridBiomeMap;
import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.mod.util.ListUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.biome.Biome;

public class BiomeMapBuilder
implements BiomeMap.Builder {
    private final Map<Biome.TempCategory, List<Biome>> rivers = new HashMap<Biome.TempCategory, List<Biome>>();
    private final Map<Biome.TempCategory, List<Biome>> wetlands = new HashMap<Biome.TempCategory, List<Biome>>();
    private final Map<Biome.TempCategory, List<Biome>> beaches = new HashMap<Biome.TempCategory, List<Biome>>();
    private final Map<Biome.TempCategory, List<Biome>> oceans = new HashMap<Biome.TempCategory, List<Biome>>();
    private final Map<Biome.TempCategory, List<Biome>> deepOceans = new HashMap<Biome.TempCategory, List<Biome>>();
    private final Map<BiomeType, List<Biome>> map = new EnumMap<BiomeType, List<Biome>>(BiomeType.class);
    private final Map<Biome, BiomeData> dataMap = new HashMap<Biome, BiomeData>();
    private final int gridSize;
    private final Function<BiomeMapBuilder, BiomeMap> constructor;

    BiomeMapBuilder(Function<BiomeMapBuilder, BiomeMap> constructor, int gridSize, List<BiomeData> biomes) {
        this.constructor = constructor;
        this.gridSize = gridSize;
        for (BiomeData data : biomes) {
            this.dataMap.put((Biome)data.reference, data);
        }
    }

    @Override
    public BiomeMapBuilder addOcean(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getTempCategory(biome);
        if (biome.func_185355_j() < -1.0f) {
            this.add(this.deepOceans.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        } else {
            this.add(this.oceans.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        }
        return this;
    }

    @Override
    public BiomeMap.Builder addBeach(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getTempCategory(biome);
        this.add(this.beaches.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMapBuilder addRiver(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getTempCategory(biome);
        this.add(this.rivers.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMapBuilder addWetland(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getTempCategory(biome);
        this.add(this.wetlands.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMapBuilder addBiome(BiomeType type, Biome biome, int count) {
        this.add(this.map.computeIfAbsent(type, t -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMap build() {
        return this.constructor.apply(this);
    }

    Biome[][] rivers() {
        return this.collectTemps(this.rivers);
    }

    Biome[][] wetlands() {
        return this.collectTemps(this.wetlands);
    }

    Biome[][] beaches() {
        return this.collectTemps(this.beaches);
    }

    Biome[][] oceans() {
        return this.collectTemps(this.oceans);
    }

    Biome[][] deepOceans() {
        return this.collectTemps(this.deepOceans);
    }

    Biome[][] biomeList() {
        return this.collectTypes(this.map);
    }

    BiomeGroup[] biomeGroups() {
        BiomeGroup[] biomes = new BiomeGroup[BiomeType.values().length];
        Function<Biome, Float> moisture = b -> Float.valueOf(this.dataMap.get((Object)b).rainfall);
        Function<Biome, Float> temperature = b -> Float.valueOf(this.dataMap.get((Object)b).temperature);
        for (BiomeType type : BiomeType.values()) {
            List list = this.map.getOrDefault((Object)type, Collections.emptyList());
            if (list.isEmpty()) continue;
            FixedGrid<Biome> grid = FixedGrid.generate(this.gridSize, list, moisture, temperature);
            biomes[type.ordinal()] = new BiomeGroup(grid);
        }
        return biomes;
    }

    private void add(List<Biome> list, Biome biome, int count) {
        for (int i = 0; i < count; ++i) {
            list.add(biome);
        }
    }

    private Biome[][] collectTemps(Map<Biome.TempCategory, List<Biome>> map) {
        Biome[][] biomes = new Biome[3][];
        for (Biome.TempCategory category : Biome.TempCategory.values()) {
            if (category == Biome.TempCategory.OCEAN) continue;
            List<Biome> list = map.getOrDefault(category, Collections.emptyList());
            list = ListUtils.minimize(list);
            list.sort(Comparator.comparing(BiomeHelper::getId));
            biomes[category.ordinal() - 1] = list.toArray(new Biome[0]);
        }
        return biomes;
    }

    private Biome[][] collectTypes(Map<BiomeType, List<Biome>> map) {
        Biome[][] biomes = new Biome[BiomeType.values().length][];
        for (BiomeType type : BiomeType.values()) {
            List<Biome> list = map.getOrDefault((Object)type, Collections.emptyList());
            list = ListUtils.minimize(list);
            list.sort(Comparator.comparing(BiomeHelper::getId));
            biomes[type.ordinal()] = list.toArray(new Biome[0]);
        }
        return biomes;
    }

    public static BiomeMap.Builder basic(List<BiomeData> biomes) {
        return new BiomeMapBuilder(BasicBiomeMap::new, 0, biomes);
    }

    public static BiomeMap.Builder grid(int size, List<BiomeData> biomes) {
        return new BiomeMapBuilder(GridBiomeMap::new, size, biomes);
    }
}

