/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk;

import com.terraforged.api.biome.BiomeVariant;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.region.chunk.ChunkReader;
import com.terraforged.core.util.PosIterator;
import com.terraforged.core.world.terrain.Terrain;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;

public class TerraContainer
extends BiomeContainer {
    private static final int BITS_WIDTH = (int)Math.round(Math.log(16.0) / Math.log(2.0)) - 2;
    private static final int ZOOM_VERT = (int)Math.round(Math.log(256.0) / Math.log(2.0)) - 2;
    public static final int SIZE = 1 << BITS_WIDTH + BITS_WIDTH + ZOOM_VERT;
    public static final int MASK_HORIZ = (1 << BITS_WIDTH) - 1;
    public static final int MASK_VERT = (1 << ZOOM_VERT) - 1;
    private final Biome[] biomes;
    private final Biome[] surface;
    private final ChunkReader chunkReader;

    public TerraContainer(Builder builder, ChunkReader chunkReader) {
        super(builder.biomes);
        this.chunkReader = chunkReader;
        this.biomes = builder.biomes;
        this.surface = builder.surfaceBiomeCache;
    }

    public Biome getBiome(int x, int z) {
        return this.surface[TerraContainer.indexOf(x, z)];
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return super.func_225526_b_(x, y, z);
    }

    public Biome getFeatureBiome() {
        PosIterator iterator = PosIterator.area(0, 0, 16, 16);
        while (iterator.next()) {
            Cell<Terrain> cell = this.chunkReader.getCell(iterator.x(), iterator.z());
            if (!cell.biomeType.isExtreme()) continue;
            return this.getBiome(iterator.x(), iterator.z());
        }
        return this.getBiome(8, 8);
    }

    public BiomeContainer bakeBiomes(boolean convertToVanilla) {
        if (convertToVanilla) {
            Biome[] biomeArray = new Biome[this.biomes.length];
            for (int i = 0; i < this.biomes.length; ++i) {
                Biome biome = this.biomes[i];
                if (biome instanceof BiomeVariant) {
                    biome = ((BiomeVariant)biome).getBase();
                }
                biomeArray[i] = biome;
            }
            return new BiomeContainer(biomeArray);
        }
        return new BiomeContainer(this.biomes);
    }

    public ChunkReader getChunkReader() {
        return this.chunkReader;
    }

    private static int indexOf(int x, int z) {
        return ((z &= 0xF) << 4) + (x &= 0xF);
    }

    private static int indexOf(int x, int y, int z) {
        y = MathHelper.func_76125_a((int)y, (int)0, (int)MASK_VERT);
        return y << BITS_WIDTH + BITS_WIDTH | (z &= MASK_HORIZ) << BITS_WIDTH | (x &= MASK_HORIZ);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Biome[] biomes = new Biome[SIZE];
        private final Biome[] surfaceBiomeCache = new Biome[256];

        public void set(int x, int z, Biome biome) {
            this.surfaceBiomeCache[TerraContainer.indexOf((int)x, (int)z)] = biome;
        }

        public TerraContainer build(ChunkReader chunkReader) {
            for (int dy = 0; dy < 64; ++dy) {
                for (int dz = 0; dz < 4; ++dz) {
                    for (int dx = 0; dx < 4; ++dx) {
                        int x = dx * 4;
                        int z = dz * 4;
                        int index = TerraContainer.indexOf(dx, dy, dz);
                        this.biomes[index] = this.surfaceBiomeCache[TerraContainer.indexOf(x, z)];
                    }
                }
            }
            return new TerraContainer(this, chunkReader);
        }
    }
}

