/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.decorator.base;

import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.api.chunk.column.DecoratorContext;
import com.terraforged.api.material.state.States;
import com.terraforged.mod.chunk.TerraContext;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.registries.ForgeRegistries;

public class BedrockDecorator
implements ColumnDecorator {
    private final int minDepth;
    private final int variance;
    private final BlockState material;

    public BedrockDecorator(TerraContext context) {
        this.minDepth = context.terraSettings.dimensions.baseLayer.minDepth;
        this.variance = context.terraSettings.dimensions.baseLayer.variance;
        this.material = BedrockDecorator.getState(context.terraSettings.dimensions.baseLayer.material);
    }

    @Override
    public void decorate(IChunk chunk, DecoratorContext context, int x, int y, int z) {
        if (this.variance <= 0) {
            this.fillDown(context, chunk, x, z, this.minDepth - 1, -1, this.material);
        } else {
            this.fillDown(context, chunk, x, z, this.minDepth + ThreadLocalRandom.current().nextInt(this.variance), -1, this.material);
        }
    }

    private static BlockState getState(String name) {
        Block block;
        ResourceLocation location = ResourceLocation.func_208304_a((String)name);
        if (location != null && ForgeRegistries.BLOCKS.containsKey(location) && (block = (Block)ForgeRegistries.BLOCKS.getValue(location)) != null) {
            return block.func_176223_P();
        }
        return (BlockState)States.BEDROCK.get();
    }
}

