/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.tree;

import com.google.gson.reflect.TypeToken;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class SaplingConfig {
    private static final TypeToken<Feature<NoFeatureConfig>> TOKEN = new TypeToken<Feature<NoFeatureConfig>>(){};
    private final Map<ResourceLocation, Integer> normal;
    private final Map<ResourceLocation, Integer> giant;

    public SaplingConfig() {
        this.normal = new HashMap<ResourceLocation, Integer>();
        this.giant = new HashMap<ResourceLocation, Integer>();
    }

    public <T> SaplingConfig(T config, DynamicOps<T> ops) {
        this.normal = this.getSection("normal", config, ops);
        this.giant = this.getSection("giant", config, ops);
    }

    public SaplingConfig addNormal(ResourceLocation name, int weight) {
        this.normal.put(name, weight);
        return this;
    }

    public SaplingConfig addNormal(String name, int weight) {
        this.normal.put(new ResourceLocation(name), weight);
        return this;
    }

    public SaplingConfig addGiant(ResourceLocation name, int weight) {
        this.giant.put(name, weight);
        return this;
    }

    public SaplingConfig addGiant(String name, int weight) {
        this.giant.put(new ResourceLocation(name), weight);
        return this;
    }

    private <T> Map<ResourceLocation, Integer> getSection(String key, T config, DynamicOps<T> ops) {
        return ops.get(config, key).flatMap(arg_0 -> ops.getMapValues(arg_0)).map(map -> {
            HashMap<ResourceLocation, Integer> backing = new HashMap<ResourceLocation, Integer>();
            for (Map.Entry entry : map.entrySet()) {
                String name = ops.getStringValue(entry.getKey()).orElse("");
                int weight = ((Number)ops.getNumberValue(entry.getValue()).orElse(0)).intValue();
                if (name.isEmpty() || weight == 0) continue;
                ResourceLocation loc = new ResourceLocation(name);
                backing.put(loc, weight);
            }
            return backing;
        }).orElse(Collections.emptyMap());
    }

    public List<Feature<NoFeatureConfig>> getNormal() {
        return SaplingConfig.build(this.normal);
    }

    public List<Feature<NoFeatureConfig>> getGiant() {
        return SaplingConfig.build(this.giant);
    }

    public static List<Feature<NoFeatureConfig>> build(Map<ResourceLocation, Integer> map) {
        LinkedList<Feature<NoFeatureConfig>> list = new LinkedList<Feature<NoFeatureConfig>>();
        for (Map.Entry<ResourceLocation, Integer> entry : map.entrySet()) {
            Feature feature = (Feature)ForgeRegistries.FEATURES.getValue(entry.getKey());
            if (feature == null || !TOKEN.getRawType().isAssignableFrom(feature.getClass())) continue;
            Feature noConfFeature = feature;
            list.add((Feature<NoFeatureConfig>)noConfFeature);
        }
        return list;
    }
}

