/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.tree;

import com.terraforged.feature.template.decorator.DecoratedFeature;
import com.terraforged.feature.template.decorator.DecoratorWorld;
import com.terraforged.feature.template.feature.TemplateFeature;
import com.terraforged.mod.feature.tree.TreeGrowBuffer;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;

public class SaplingPlacer {
    public static boolean placeTree(Feature<NoFeatureConfig> feature, SaplingGrowTreeEvent event, Vec3i[] dirs) {
        if (feature == null) {
            return false;
        }
        event.setResult(Event.Result.DENY);
        if (feature instanceof DecoratedFeature) {
            return SaplingPlacer.placeDecorated((DecoratedFeature)feature, event, dirs);
        }
        return SaplingPlacer.placeNormal(feature, event, dirs);
    }

    private static <W extends DecoratorWorld> boolean placeDecorated(DecoratedFeature<?, W> feature, SaplingGrowTreeEvent event, Vec3i[] dirs) {
        if (!(event.getWorld().func_72863_F() instanceof ServerChunkProvider)) {
            return false;
        }
        TreeGrowBuffer buffer = new TreeGrowBuffer(event.getWorld(), event.getPos());
        W world = feature.wrap(buffer);
        ChunkGenerator generator = ((ServerChunkProvider)event.getWorld().func_72863_F()).func_201711_g();
        feature.placeFeature(world, (ChunkGenerator<GenerationSettings>)generator, event.getRand(), event.getPos(), NoFeatureConfig.field_202429_e);
        if (SaplingPlacer.overheadIsSolid(event.getWorld(), event.getPos(), buffer.getTopY())) {
            return false;
        }
        BlockPos translation = buffer.getBaseMin().func_177971_a(SaplingPlacer.getMin(dirs));
        SaplingPlacer.applyBuffer(buffer, event.getWorld(), translation);
        world.setDelegate(event.getWorld());
        world.translate(translation);
        feature.decorate(world, event.getRand());
        return true;
    }

    private static boolean placeNormal(Feature<NoFeatureConfig> feature, SaplingGrowTreeEvent event, Vec3i[] dirs) {
        TreeGrowBuffer buffer = new TreeGrowBuffer(event.getWorld(), event.getPos());
        buffer.placeFeature(feature, event.getPos(), event.getRand());
        if (SaplingPlacer.overheadIsSolid(event.getWorld(), event.getPos(), buffer.getTopY())) {
            return false;
        }
        BlockPos translation = buffer.getBaseMin().func_177971_a(SaplingPlacer.getMin(dirs));
        SaplingPlacer.applyBuffer(buffer, event.getWorld(), translation);
        return true;
    }

    private static void applyBuffer(TreeGrowBuffer buffer, IWorld world, BlockPos translation) {
        try (BlockPos.PooledMutable pos = BlockPos.PooledMutable.func_185346_s();){
            for (TemplateFeature.BlockInfo block : buffer.getChanges()) {
                int x = block.getPos().func_177958_n() + translation.func_177958_n();
                int y = block.getPos().func_177956_o();
                int z = block.getPos().func_177952_p() + translation.func_177952_p();
                pos.func_181079_c(x, y, z);
                BlockState current = world.func_180495_p((BlockPos)pos);
                if (current.func_200132_m()) continue;
                world.func_180501_a((BlockPos)pos, block.getState(), 2);
            }
        }
    }

    private static boolean overheadIsSolid(IWorld world, BlockPos pos, int topY) {
        try (BlockPos.PooledMutable blockPos = BlockPos.PooledMutable.func_185346_s();){
            for (int y = pos.func_177956_o(); y <= topY; ++y) {
                blockPos.func_181079_c(pos.func_177958_n(), y, pos.func_177952_p());
                BlockState state = world.func_180495_p(pos);
                if (!state.func_200132_m()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static Vec3i getMin(Vec3i[] dirs) {
        Vec3i min = Vec3i.field_177959_e;
        for (Vec3i dir : dirs) {
            if (dir.func_177958_n() < min.func_177958_n() && dir.func_177952_p() <= min.func_177952_p()) {
                min = dir;
                continue;
            }
            if (dir.func_177952_p() >= min.func_177952_p() || dir.func_177958_n() > min.func_177958_n()) continue;
            min = dir;
        }
        return min;
    }
}

