/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.element;

import com.terraforged.mod.gui.element.Element;
import com.terraforged.mod.gui.element.TerraButton;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;

public class TerraToggle
extends TerraButton {
    private final String prefix;
    private final CompoundNBT value;
    private final ListNBT options;
    private final List<String> tooltip;
    private int index;
    private Runnable callback = () -> {};

    public TerraToggle(String prefix, CompoundNBT value) {
        super(value.func_74779_i("value"));
        this.value = value;
        this.prefix = prefix;
        this.tooltip = Element.readTooltip(value);
        this.options = value.func_150295_c("#options", 8);
        for (int i = 0; i < this.options.size(); ++i) {
            String s = this.options.func_150307_f(i);
            if (!s.equals(value.func_74779_i("value"))) continue;
            this.index = i;
            break;
        }
        this.setMessage(prefix + value.func_74779_i("value"));
    }

    public TerraToggle callback(Runnable runnable) {
        this.callback = runnable;
        return this;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (super.isValidClickButton(button)) {
            int direction = button == 0 ? 1 : -1;
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            this.onClick(mx, my, direction);
            return true;
        }
        return false;
    }

    private void onClick(double mouseX, double mouseY, int direction) {
        super.onClick(mouseX, mouseY);
        this.index += direction;
        if (this.index >= this.options.size()) {
            this.index = 0;
        } else if (this.index < 0) {
            this.index = this.options.size() - 1;
        }
        String option = this.options.func_150307_f(this.index);
        this.value.func_74778_a("value", option);
        this.setMessage(this.prefix + option);
        this.callback.run();
    }
}

