/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.page;

import com.terraforged.core.settings.Settings;
import com.terraforged.mod.gui.OverlayScreen;
import com.terraforged.mod.gui.page.BasePage;
import com.terraforged.mod.gui.page.Page;
import com.terraforged.mod.gui.preview.PreviewPage;
import com.terraforged.mod.util.nbt.NBTHelper;
import net.minecraft.nbt.CompoundNBT;

public class RiverPage
extends BasePage {
    private final Settings settings;
    private final PreviewPage preview;
    private final CompoundNBT riverSettings;

    public RiverPage(Settings settings, PreviewPage preview) {
        this.settings = settings;
        this.preview = preview;
        this.riverSettings = NBTHelper.serialize(settings.rivers);
    }

    @Override
    public String getTitle() {
        return "River Settings";
    }

    @Override
    public void save() {
        NBTHelper.deserialize(this.riverSettings, this.settings.rivers);
    }

    @Override
    public void init(OverlayScreen parent) {
        Page.Column center = this.getColumn(0);
        center.scrollPane.setScrollAmount(0.0);
        this.addElements(0, 0, center, this.riverSettings, true, center.scrollPane::addButton, this::update);
    }

    @Override
    protected void update() {
        super.update();
        this.preview.apply(settings -> NBTHelper.deserialize(this.riverSettings, settings.rivers));
    }
}

