/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.settings;

import com.terraforged.core.util.serialization.annotation.Comment;
import com.terraforged.core.util.serialization.annotation.Range;
import com.terraforged.core.util.serialization.annotation.Serializable;
import com.terraforged.mod.TerraWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldInfo;
import org.jline.utils.Log;

@Serializable
public class DimesionSettings {
    public BaseDecorator baseLayer = new BaseDecorator();
    public DimensionGenerators dimensionGenerators = new DimensionGenerators();

    public static WorldType getWorldType(WorldInfo info, DimensionType type) {
        String generator = info.func_186347_a(type).func_74779_i("TerraDelegateGenerator");
        return DimesionSettings.getWorldType(generator);
    }

    private static void set(WorldInfo info, DimensionType type, String value) {
        CompoundNBT data = info.func_186347_a(type);
        data.func_218657_a("TerraDelegateGenerator", (INBT)StringNBT.func_229705_a_((String)DimesionSettings.getWorldType(value).func_211888_a()));
        info.func_186345_a(type, data);
    }

    private static WorldType getWorldType(String name) {
        WorldType type = WorldType.func_77130_a((String)name);
        if (type == null) {
            Log.warn((Object[])new Object[]{"WorldType {} does not exist. Reverting to default", name});
            return WorldType.field_77137_b;
        }
        if (TerraWorld.isTerraType(type)) {
            Log.warn((Object[])new Object[]{"Cannot set TerraForged as world type for {}", name});
            return WorldType.field_77137_b;
        }
        return type;
    }

    @Serializable
    public static class DimensionGenerators {
        @Comment(value={"Select the nether generator"})
        public String nether = "default";
        @Comment(value={"Select the end generator"})
        public String end = "default";

        public void apply(WorldInfo info) {
            DimesionSettings.set(info, DimensionType.field_223228_b_, this.nether);
            DimesionSettings.set(info, DimensionType.field_223229_c_, this.end);
        }
    }

    @Serializable
    public static class BaseDecorator {
        @Comment(value={"Controls the material that should be used in the world's base layer"})
        public String material = "minecraft:bedrock";
        @Range(min=0.0f, max=10.0f)
        @Comment(value={"Controls the minimum height of the world's base layer"})
        public int minDepth = 1;
        @Range(min=0.0f, max=10.0f)
        @Comment(value={"Controls the amount of height randomness of the world's base layer"})
        public int variance = 4;
    }
}

