/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.selector;

import me.dags.noise.Module;
import me.dags.noise.func.Interpolation;
import me.dags.noise.selector.Selector;

public class Base
extends Selector {
    private final Module base;
    protected final float min;
    protected final float max;
    protected final float maxValue;
    protected final float falloff;

    public Base(Module base, Module source, float falloff, Interpolation interpolation) {
        super(source, new Module[]{base, source}, interpolation);
        this.base = base;
        this.min = base.maxValue();
        this.max = base.maxValue() + falloff;
        this.falloff = falloff;
        this.maxValue = Math.max(base.maxValue(), source.maxValue());
    }

    @Override
    protected float selectValue(float x, float y, float upperValue) {
        if (upperValue < this.max) {
            float lowerValue = this.base.getValue(x, y);
            if (this.falloff > 0.0f) {
                float clamp = Math.max(this.min, upperValue);
                float alpha = (this.max - clamp) / this.falloff;
                return this.blendValues(upperValue, lowerValue, alpha);
            }
            return lowerValue;
        }
        return upperValue;
    }

    @Override
    public float minValue() {
        return this.base.minValue();
    }

    @Override
    public float maxValue() {
        return this.maxValue;
    }
}

