/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.source;

import me.dags.noise.Module;
import me.dags.noise.source.Builder;
import me.dags.noise.util.Noise;
import me.dags.noise.util.NoiseUtil;

public class Rand
implements Module {
    private final int seed;
    private final float frequency;

    public Rand(Builder builder) {
        this.seed = builder.getSeed();
        this.frequency = builder.getFrequency();
    }

    @Override
    public float getValue(float x, float y) {
        float value = Noise.white(x *= this.frequency, y *= this.frequency, this.seed);
        return Math.abs(value);
    }

    public float getValue(float x, float y, int childSeed) {
        return Noise.white(x, y, NoiseUtil.hash(this.seed, childSeed));
    }

    public int nextInt(float x, float y, int range) {
        float noise = this.getValue(x, y);
        return NoiseUtil.round((float)range * noise / (float)(range + range));
    }

    public int nextInt(float x, float y, int childSeed, int range) {
        float noise = this.getValue(x, y, childSeed);
        return NoiseUtil.round((float)range * noise / (float)(range + range));
    }
}

