/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.buzzierbees.client.render;

import com.bagel.buzzierbees.common.entities.HoneySlimeEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.layers.SlimeGelLayer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HoneySlimeRenderer
extends MobRenderer<HoneySlimeEntity, SlimeModel<HoneySlimeEntity>> {
    private static final ResourceLocation HONEY_SLIME_TEXTURES = new ResourceLocation("buzzierbees:textures/entity/honey_slime.png");
    private static final ResourceLocation DESTICKED_HONEY_SLIME_TEXTURES = new ResourceLocation("buzzierbees:textures/entity/honey_slime_bottled.png");

    public HoneySlimeRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new SlimeModel(16), 0.25f);
        this.func_177094_a((LayerRenderer)new SlimeGelLayer((IEntityRenderer)this));
    }

    public void render(HoneySlimeEntity honeySlimeEntity, float f1, float f2, MatrixStack matrixStack, IRenderTypeBuffer RenderTypeBuffer, int i) {
        this.field_76989_e = 0.25f * (float)(honeySlimeEntity.func_70631_g_() ? 1 : 2);
        super.func_225623_a_((MobEntity)honeySlimeEntity, f1, f2, matrixStack, RenderTypeBuffer, i);
    }

    protected void preRenderCallback(HoneySlimeEntity honeySlimeEntity, MatrixStack matrixStack, float f) {
        float f0 = 0.999f;
        matrixStack.func_227862_a_(0.999f, 0.999f, 0.999f);
        matrixStack.func_227861_a_(0.0, (double)0.001f, 0.0);
        float f1 = honeySlimeEntity.func_70631_g_() ? 1 : 2;
        float f2 = MathHelper.func_219799_g((float)f, (float)honeySlimeEntity.prevSquishFactor, (float)honeySlimeEntity.squishFactor) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        matrixStack.func_227862_a_(f3 * f1, 1.0f / f3 * f1, f3 * f1);
    }

    public ResourceLocation getEntityTexture(HoneySlimeEntity entity) {
        return entity.isInHoney() ? HONEY_SLIME_TEXTURES : DESTICKED_HONEY_SLIME_TEXTURES;
    }
}

