/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.buzzierbees.common.blocks;

import com.bagel.buzzierbees.core.util.BlockStateUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CandleBlock
extends Block
implements IWaterLoggable {
    public static final IntegerProperty CANDLES = BlockStateUtils.CANDLES_1_4;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty LIT = BlockStateUtils.LIT;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape ONE_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    protected static final VoxelShape TWO_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
    protected static final VoxelShape THREE_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
    protected static final VoxelShape FOUR_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);

    public CandleBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)CANDLES, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public int func_149750_m(BlockState state) {
        return this.isInBadEnvironment(state) ? 0 : super.func_149750_m(state) + (11 + 1 * (Integer)state.func_177229_b((IProperty)CANDLES));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        Direction direction = context.func_195992_f();
        if (blockstate.func_177230_c() == this) {
            return (BlockState)((BlockState)blockstate.func_206870_a((IProperty)FACING, (Comparable)direction)).func_206870_a((IProperty)CANDLES, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.func_177229_b((IProperty)CANDLES) + 1)));
        }
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)direction)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    private boolean isInBadEnvironment(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.isValidGround(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return !state.func_196952_d(worldIn, pos).func_212434_a(Direction.UP).func_197766_b();
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        return 0.1f * (float)((Integer)state.func_177229_b((IProperty)CANDLES)).intValue();
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!state.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(state, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((IProperty)CANDLES) < 4 ? true : super.func_196253_a(state, useContext);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Integer)state.func_177229_b((IProperty)CANDLES)) {
            default: {
                return ONE_SHAPE;
            }
            case 2: {
                return TWO_SHAPE;
            }
            case 3: {
                return THREE_SHAPE;
            }
            case 4: 
        }
        return FOUR_SHAPE;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CANDLES, WATERLOGGED, LIT, FACING});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.AIR && !this.field_196274_w ? true : super.func_196266_a(state, worldIn, pos, type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            double x = pos.func_177958_n();
            double y = pos.func_177956_o();
            double z = pos.func_177952_p();
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 1) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5, y + 0.75, z + 0.5, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5, y + 0.75, z + 0.5, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.NORTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5625, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5625, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.EAST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.5625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.5625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.SOUTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.4375, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.4375, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 2 && state.func_177229_b((IProperty)FACING) == Direction.WEST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.4375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.4375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.NORTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5, y + 0.6875, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5, y + 0.6875, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.EAST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.SOUTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.5, y + 0.6875, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.5, y + 0.6875, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 3 && state.func_177229_b((IProperty)FACING) == Direction.WEST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.6875, z + 0.5, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.NORTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.625, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.EAST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.6875, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.625, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.SOUTH) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.625, z + 0.625, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.4375, z + 0.3125, 0.002, 0.01, 0.002);
            }
            if ((Integer)state.func_177229_b((IProperty)CANDLES) == 4 && state.func_177229_b((IProperty)FACING) == Direction.WEST) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.3125, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.3125, y + 0.75, z + 0.3125, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.625, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.625, y + 0.6875, z + 0.375, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.375, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.375, y + 0.625, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.6875, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 0.6875, y + 0.4375, z + 0.6875, 0.002, 0.01, 0.002);
            }
        }
    }
}

