/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.buzzierbees.core.registry;

import com.bagel.buzzierbees.common.world.features.DirectionalFlowersFeature;
import com.bagel.buzzierbees.core.registry.BBBlocks;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.DefaultFlowersFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BBFeatures {
    public static final DefaultFlowersFeature DEFAULT_FLOWERS_FEATURE = new DefaultFlowersFeature(BlockClusterFeatureConfig::func_227300_a_);
    public static final DirectionalFlowersFeature DIRECTIONAL_FLOWERS_FEATURE = new DirectionalFlowersFeature(BlockClusterFeatureConfig::func_227300_a_);

    private static void addShortFlower(BlockState blockState, Biome biomeIn, int frequency) {
        BlockClusterFeatureConfig config = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(blockState), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, DEFAULT_FLOWERS_FEATURE.func_225566_b_((IFeatureConfig)config).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    private static void addDirectionalFlower(BlockState blockState, Biome biomeIn, int frequency) {
        BlockClusterFeatureConfig config = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(blockState), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, DIRECTIONAL_FLOWERS_FEATURE.func_225566_b_((IFeatureConfig)config).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addDoubleFlower(BlockState blockState, Biome biomeIn, int frequency) {
        BlockClusterFeatureConfig config = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(blockState), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202291_ak.func_225566_b_((IFeatureConfig)new MultipleWithChanceRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config)), 0)).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addFeatures() {
        ForgeRegistries.BIOMES.getValues().forEach(BBFeatures::generate);
    }

    public static void generate(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.JUNGLE) {
            BBFeatures.addDoubleFlower(((Block)BBBlocks.BIRD_OF_PARADISE.get()).func_176223_P(), biome, 5);
            BBFeatures.addShortFlower(((Block)BBBlocks.YELLOW_HIBISCUS.get()).func_176223_P(), biome, 1);
            BBFeatures.addShortFlower(((Block)BBBlocks.ORANGE_HIBISCUS.get()).func_176223_P(), biome, 1);
            BBFeatures.addShortFlower(((Block)BBBlocks.RED_HIBISCUS.get()).func_176223_P(), biome, 1);
            BBFeatures.addShortFlower(((Block)BBBlocks.PINK_HIBISCUS.get()).func_176223_P(), biome, 1);
            BBFeatures.addShortFlower(((Block)BBBlocks.MAGENTA_HIBISCUS.get()).func_176223_P(), biome, 1);
            BBFeatures.addShortFlower(((Block)BBBlocks.PURPLE_HIBISCUS.get()).func_176223_P(), biome, 1);
        }
        if (biome.func_201856_r() == Biome.Category.SWAMP) {
            BBFeatures.addShortFlower(((Block)BBBlocks.DIANTHUS.get()).func_176223_P(), biome, 5);
        }
        if (biome.func_201856_r() == Biome.Category.SAVANNA) {
            BBFeatures.addShortFlower(Blocks.field_196609_bf.func_176223_P(), biome, 4);
        }
        if (biome.func_201856_r() == Biome.Category.TAIGA) {
            BBFeatures.addShortFlower(((Block)BBBlocks.VIOLET.get()).func_176223_P(), biome, 4);
        }
        if (biome.func_201856_r() == Biome.Category.EXTREME_HILLS) {
            BBFeatures.addShortFlower(((Block)BBBlocks.COLUMBINE.get()).func_176223_P(), biome, 4);
        }
        if (biome.func_201856_r() == Biome.Category.FOREST) {
            if (biome == Biomes.field_185444_T) {
                BBFeatures.addDirectionalFlower(((Block)BBBlocks.CARTWHEEL.get()).func_176223_P(), biome, 5);
                BBFeatures.addShortFlower(((Block)BBBlocks.PINK_CLOVER.get()).func_176223_P(), biome, 3);
            }
            if (biome == Biomes.field_150585_R || biome == Biomes.field_185430_ab) {
                BBFeatures.addShortFlower(((Block)BBBlocks.BLUEBELL.get()).func_176223_P(), biome, 3);
            }
            if (biome == Biomes.field_150583_P || biome == Biomes.field_150582_Q || biome == Biomes.field_185448_Z || biome == Biomes.field_185429_aa) {
                BBFeatures.addShortFlower(((Block)BBBlocks.PINK_CLOVER.get()).func_176223_P(), biome, 3);
            } else {
                BBFeatures.addShortFlower(((Block)BBBlocks.WHITE_CLOVER.get()).func_176223_P(), biome, 3);
            }
        }
    }
}

