/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.IWorldWrapper;
import cjminecraft.doubleslabs.api.ServerWorldWrapper;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.WorldWrapper;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BlockInfo
implements IBlockInfo,
INBTSerializable<CompoundNBT>,
ICapabilityProvider {
    private ISlabSupport support;
    private BlockState state;
    private TileEntity tile;
    private IWorldWrapper<?> world;
    private final SlabTileEntity slab;
    private final boolean positive;

    public BlockInfo(SlabTileEntity slab, boolean positive) {
        this.slab = slab;
        this.positive = positive;
    }

    @Override
    @Nullable
    public BlockState getBlockState() {
        return this.state;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity() {
        return this.tile;
    }

    @Override
    @Nonnull
    public World getWorld() {
        return (World)this.world;
    }

    @Override
    public boolean isPositive() {
        return this.positive;
    }

    @Override
    public BlockPos getPos() {
        return this.slab.func_174877_v();
    }

    @Override
    @Nullable
    public ISlabSupport getSupport() {
        return this.support;
    }

    @Override
    public void setBlockState(@Nullable BlockState state) {
        if (this.state != null && this.state.hasTileEntity() && this.tile != null) {
            this.tile.func_145836_u();
        }
        if (this.state != null && state != null && (this.state.func_177230_c() != state.func_177230_c() || !state.hasTileEntity()) && this.state.hasTileEntity()) {
            this.setTileEntity(null);
        }
        if (this.state == null) {
            this.setTileEntity(null);
        }
        this.state = state;
        if (state != null && state.hasTileEntity()) {
            if (this.tile == null) {
                this.setTileEntity(state.createTileEntity((IBlockReader)this.getWorld()));
            } else {
                this.tile.func_145836_u();
            }
        }
        this.slab.markDirtyClient();
        this.support = state == null ? null : SlabSupport.getSlabSupport((IBlockReader)this.getWorld(), this.getPos(), this.state);
    }

    @Override
    public void setTileEntity(@Nullable TileEntity tile) {
        if (tile != null) {
            if (this.tile != null) {
                this.tile.func_226984_a_(this.slab.func_145831_w(), this.slab.func_174877_v());
                this.tile.func_145843_s();
            }
            tile.func_226984_a_(this.slab.func_145831_w(), this.slab.func_174877_v());
            tile.onLoad();
            tile.func_226984_a_(this.getWorld(), this.slab.func_174877_v());
        }
        this.tile = tile;
    }

    public void setWorld(World world) {
        if (this.world != null) {
            this.world.setWorld(world);
        } else {
            this.world = world instanceof ServerWorld ? new ServerWorldWrapper((ServerWorld)world) : new WorldWrapper(world);
        }
        this.world.setPositive(this.positive);
        this.world.setBlockPos(this.slab.func_174877_v());
        this.world.setStateContainer(this.slab);
        if (this.tile != null) {
            this.tile.func_226984_a_(this.getWorld(), this.slab.func_174877_v());
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.state != null) {
            nbt.func_218657_a("state", (INBT)NBTUtil.func_190009_a((BlockState)this.state));
        }
        if (this.tile != null) {
            nbt.func_218657_a("tile", (INBT)this.tile.func_189515_b(new CompoundNBT()));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("state")) {
            this.state = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("state"));
        }
        if (nbt.func_74764_b("tile")) {
            this.tile = TileEntity.func_203403_c((CompoundNBT)nbt.func_74775_l("tile"));
        }
    }

    public void onLoad() {
        if (this.tile != null) {
            this.tile.func_226984_a_(this.getWorld(), this.slab.func_174877_v());
            this.tile.onLoad();
        }
    }

    public void onChunkUnloaded() {
        if (this.tile != null) {
            this.tile.onChunkUnloaded();
        }
    }

    public void remove() {
        if (this.tile != null) {
            this.tile.func_226984_a_(this.slab.func_145831_w(), this.slab.func_174877_v());
            this.tile.func_145843_s();
            this.tile = null;
        }
    }

    public void validate() {
        if (this.tile != null) {
            this.tile.func_145829_t();
        }
    }

    public void updateContainingBlockInfo() {
        if (this.tile != null) {
            this.tile.func_145836_u();
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.tile != null ? this.tile.getCapability(cap, side) : LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return this.tile != null ? this.tile.getCapability(cap) : LazyOptional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockInfo blockInfo = (BlockInfo)o;
        return this.positive == blockInfo.positive && Objects.equals(this.state, blockInfo.state) && Objects.equals(this.tile, blockInfo.tile);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.tile, this.positive);
    }
}

