/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.blockcarpentry;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@SlabSupportProvider(modid="blockcarpentry")
public class BlockCarpentrySlabSupport<T extends Enum<T>>
implements IHorizontalSlabSupport,
IVerticalSlabSupport {
    private final Class<?> slab;

    public BlockCarpentrySlabSupport() {
        Class<?> slab;
        try {
            slab = Class.forName("mod.pianomanu.blockcarpentry.block.SixWaySlabFrameBlock");
        }
        catch (ClassNotFoundException ignored) {
            slab = null;
        }
        this.slab = slab;
    }

    @Override
    public boolean isHorizontalSlab(IBlockReader world, BlockPos pos, BlockState state) {
        return this.slab != null && this.slab.isAssignableFrom(state.func_177230_c().getClass()) && ((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k().func_200128_b();
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return this.slab != null && item instanceof BlockItem && this.slab.isAssignableFrom(((BlockItem)item).func_179223_d().getClass());
    }

    @Override
    public SlabType getHalf(World world, BlockPos pos, BlockState state) {
        return state.func_177229_b((IProperty)BlockStateProperties.field_208155_H) == Direction.DOWN ? SlabType.TOP : SlabType.BOTTOM;
    }

    @Override
    public BlockState getStateForHalf(World world, BlockPos pos, BlockState state, SlabType half) {
        return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)(half == SlabType.BOTTOM ? Direction.UP : Direction.DOWN));
    }

    @Override
    public boolean isVerticalSlab(IBlockReader world, BlockPos pos, BlockState state) {
        return this.slab != null && this.slab.isAssignableFrom(state.func_177230_c().getClass()) && ((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k().func_176722_c();
    }

    @Override
    public boolean isVerticalSlab(ItemStack stack, PlayerEntity player, Hand hand) {
        return this.slab != null && stack.func_77973_b() instanceof BlockItem && this.slab.isAssignableFrom(((BlockItem)stack.func_77973_b()).func_179223_d().getClass());
    }

    @Override
    public Direction getDirection(World world, BlockPos pos, BlockState state) {
        return ((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176734_d();
    }

    @Override
    public BlockState getStateForDirection(World world, BlockPos pos, BlockState state, Direction direction) {
        return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)direction.func_176734_d());
    }

    @Override
    public boolean useDoubleSlabModel(BlockState state) {
        return false;
    }
}

