/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.worldofwonder;

import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@SlabSupportProvider(modid="worldofwonder")
public class WorldOfWonderDirectionVerticalSlabSupport<T extends Enum<T>>
implements IVerticalSlabSupport {
    private final Class<?> verticalSlab;
    private final EnumProperty<T> verticalSlabTypeProperty;
    private final DirectionProperty verticalSlabFacingProperty;
    private final T[] verticalSlabTypes;

    public WorldOfWonderDirectionVerticalSlabSupport() {
        Enum[] verticalSlabTypes;
        DirectionProperty verticalSlabFacingProperty;
        EnumProperty verticalSlabTypeProperty;
        Class<?> verticalSlab;
        try {
            verticalSlab = Class.forName("net.msrandom.worldofwonder.block.DirectionalVerticalSlabBlock");
            verticalSlabTypeProperty = (EnumProperty)verticalSlab.getField("TYPE").get(null);
            verticalSlabFacingProperty = (DirectionProperty)verticalSlab.getField("FACING").get(null);
            Class<?> verticalSlabType = Class.forName("net.msrandom.worldofwonder.block.DirectionalVerticalSlabBlock$VerticalSlabType");
            verticalSlabTypes = (Enum[])verticalSlabType.getEnumConstants();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            verticalSlab = null;
            verticalSlabTypeProperty = null;
            verticalSlabFacingProperty = null;
            verticalSlabTypes = null;
        }
        this.verticalSlab = verticalSlab;
        this.verticalSlabTypeProperty = verticalSlabTypeProperty;
        this.verticalSlabFacingProperty = verticalSlabFacingProperty;
        this.verticalSlabTypes = verticalSlabTypes;
    }

    @Override
    public boolean isVerticalSlab(IBlockReader world, BlockPos pos, BlockState state) {
        return this.verticalSlab != null && state.func_177230_c().getClass().equals(this.verticalSlab) && !((Enum)((Object)state.func_177229_b(this.verticalSlabTypeProperty))).equals(this.verticalSlabTypes[1]);
    }

    @Override
    public boolean isVerticalSlab(ItemStack stack, PlayerEntity player, Hand hand) {
        return this.verticalSlab != null && stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d().getClass().equals(this.verticalSlab);
    }

    @Override
    public BlockState getStateForDirection(World world, BlockPos pos, BlockState state, Direction direction) {
        return this.verticalSlab == null ? state : (BlockState)state.func_206870_a((IProperty)this.verticalSlabFacingProperty, (Comparable)direction);
    }

    @Override
    public Direction getDirection(World world, BlockPos pos, BlockState state) {
        if (this.verticalSlab == null) {
            return null;
        }
        return (Direction)state.func_177229_b((IProperty)this.verticalSlabFacingProperty);
    }
}

