/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.client.util.ClientUtils;
import cjminecraft.doubleslabs.client.util.CullInfo;
import cjminecraft.doubleslabs.client.util.SlabCacheKey;
import cjminecraft.doubleslabs.client.util.vertex.TintOffsetTransformer;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class DoubleSlabBakedModel
extends DynamicSlabBakedModel {
    private List<BakedQuad> getQuadsForState(SlabCacheKey cache, boolean positive) {
        BlockState state;
        BlockState blockState = state = positive ? cache.getPositiveBlockInfo().getBlockState() : cache.getNegativeBlockInfo().getBlockState();
        if (state == null) {
            return new ArrayList<BakedQuad>();
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        EmptyModelData tileData = positive ? (cache.getPositiveBlockInfo().getTileEntity() != null ? cache.getPositiveBlockInfo().getTileEntity().getModelData() : EmptyModelData.INSTANCE) : (cache.getNegativeBlockInfo().getTileEntity() != null ? cache.getNegativeBlockInfo().getTileEntity().getModelData() : EmptyModelData.INSTANCE);
        IModelData modelData = model.getModelData((ILightReader)(positive ? cache.getPositiveBlockInfo().getWorld() : cache.getNegativeBlockInfo().getWorld()), cache.getPositiveBlockInfo().getPos(), state, (IModelData)tileData);
        return model.getQuads(state, cache.getSide(), cache.getRandom(), modelData).stream().map(quad -> {
            BakedQuadBuilder builder = new BakedQuadBuilder();
            TintOffsetTransformer transformer = new TintOffsetTransformer((IVertexConsumer)builder, positive);
            quad.pipe((IVertexConsumer)transformer);
            return builder.build();
        }).collect(Collectors.toList());
    }

    @Override
    protected Block getBlock() {
        return (Block)DSBlocks.DOUBLE_SLAB.get();
    }

    @Override
    protected List<BakedQuad> getQuads(SlabCacheKey cache) {
        IHorizontalSlabSupport horizontalSlabSupport;
        boolean shouldCull;
        ArrayList<Object> quads = new ArrayList<BakedQuad>();
        if (cache.getPositiveBlockInfo().getBlockState() == null || cache.getNegativeBlockInfo().getBlockState() == null) {
            return ClientConstants.getFallbackModel().getQuads(null, cache.getSide(), cache.getRandom(), (IModelData)EmptyModelData.INSTANCE);
        }
        boolean topTransparent = ClientUtils.isTransparent(cache.getPositiveBlockInfo().getBlockState());
        boolean bottomTransparent = ClientUtils.isTransparent(cache.getNegativeBlockInfo().getBlockState());
        boolean bl = shouldCull = DSConfig.CLIENT.shouldCull(cache.getPositiveBlockInfo().getBlockState().func_177230_c()) && DSConfig.CLIENT.shouldCull(cache.getNegativeBlockInfo().getBlockState().func_177230_c()) && (!topTransparent || !bottomTransparent || cache.getPositiveBlockInfo().getBlockState().func_177230_c() == cache.getNegativeBlockInfo().getBlockState().func_177230_c() && cache.getPositiveBlockInfo().getBlockState().func_177230_c() == cache.getNegativeBlockInfo().getBlockState().func_177230_c());
        if (this.useDoubleSlabModel(cache.getPositiveBlockInfo().getBlockState(), cache.getNegativeBlockInfo().getBlockState()) && (horizontalSlabSupport = SlabSupport.isHorizontalSlab((IBlockReader)cache.getPositiveBlockInfo().getWorld(), cache.getPositiveBlockInfo().getPos(), cache.getPositiveBlockInfo().getBlockState())) != null && horizontalSlabSupport.useDoubleSlabModel(cache.getPositiveBlockInfo().getBlockState())) {
            BlockState state = horizontalSlabSupport.getStateForHalf(cache.getPositiveBlockInfo().getWorld(), cache.getPositiveBlockInfo().getPos(), cache.getPositiveBlockInfo().getBlockState(), SlabType.DOUBLE);
            if (RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)cache.getRenderLayer()) || cache.getRenderLayer() == null) {
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
                quads = new ArrayList(model.getQuads(state, cache.getSide(), cache.getRandom(), (IModelData)EmptyModelData.INSTANCE));
                if (cache.getSide() != null) {
                    for (CullInfo cullInfo : cache.getCullInfo()) {
                        if (cullInfo.getPositiveBlockInfo().getBlockState() != null && cullInfo.getNegativeBlockInfo().getBlockState() != null && this.useDoubleSlabModel(cullInfo.getPositiveBlockInfo().getBlockState(), cullInfo.getNegativeBlockInfo().getBlockState())) {
                            BlockState s;
                            IHorizontalSlabSupport support = SlabSupport.isHorizontalSlab((IBlockReader)cullInfo.getPositiveBlockInfo().getWorld(), cullInfo.getPositiveBlockInfo().getPos(), cullInfo.getPositiveBlockInfo().getBlockState());
                            if (support == null || !this.shouldCull(state, s = support.getStateForHalf(cullInfo.getPositiveBlockInfo().getWorld(), cullInfo.getPositiveBlockInfo().getPos(), cullInfo.getPositiveBlockInfo().getBlockState(), SlabType.DOUBLE), cullInfo.getDirection())) continue;
                            quads.removeIf(quad -> quad.func_178210_d() == cullInfo.getDirection());
                            continue;
                        }
                        if (!this.shouldCull(state, cullInfo.getPositiveBlockInfo().getBlockState(), cullInfo.getDirection()) && !this.shouldCull(state, cullInfo.getNegativeBlockInfo().getBlockState(), cullInfo.getDirection())) continue;
                        quads.removeIf(quad -> quad.func_178210_d() == cullInfo.getDirection());
                    }
                }
                return quads;
            }
            return new ArrayList<BakedQuad>();
        }
        if (RenderTypeLookup.canRenderInLayer((BlockState)cache.getPositiveBlockInfo().getBlockState(), (RenderType)cache.getRenderLayer()) || cache.getRenderLayer() == null) {
            List<BakedQuad> topQuads = this.getQuadsForState(cache, true);
            if (shouldCull && (!bottomTransparent && !topTransparent || topTransparent && !bottomTransparent || topTransparent && bottomTransparent)) {
                topQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == Direction.DOWN);
            }
            if (cache.getSide() != null) {
                for (CullInfo cullInfo : cache.getCullInfo()) {
                    if (!this.shouldCull(cache.getPositiveBlockInfo().getBlockState(), cullInfo.getPositiveBlockInfo().getBlockState(), cullInfo.getDirection())) continue;
                    topQuads.removeIf(quad -> quad.func_178210_d() == cullInfo.getDirection());
                }
            }
            quads.addAll(topQuads);
        }
        if (RenderTypeLookup.canRenderInLayer((BlockState)cache.getNegativeBlockInfo().getBlockState(), (RenderType)cache.getRenderLayer()) || cache.getRenderLayer() == null) {
            List<BakedQuad> bottomQuads = this.getQuadsForState(cache, false);
            if (shouldCull && (!topTransparent && !bottomTransparent || bottomTransparent && !topTransparent || topTransparent && bottomTransparent)) {
                bottomQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == Direction.UP);
            }
            if (cache.getSide() != null) {
                for (CullInfo cullInfo : cache.getCullInfo()) {
                    if (!this.shouldCull(cache.getNegativeBlockInfo().getBlockState(), cullInfo.getNegativeBlockInfo().getBlockState(), cullInfo.getDirection())) continue;
                    bottomQuads.removeIf(quad -> quad.func_178210_d() == cullInfo.getDirection());
                }
            }
            quads.addAll(bottomQuads);
        }
        return quads;
    }
}

