/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.util.ClientUtils;
import cjminecraft.doubleslabs.client.util.CullInfo;
import cjminecraft.doubleslabs.client.util.SlabCacheKey;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.logging.log4j.Level;

public abstract class DynamicSlabBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<IBlockInfo> NEGATIVE_BLOCK = new ModelProperty();
    public static final ModelProperty<IBlockInfo> POSITIVE_BLOCK = new ModelProperty();
    private static final ModelProperty<List<CullInfo>> CULL_DIRECTIONS = new ModelProperty();
    private final Cache<SlabCacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build();

    public boolean func_177555_b() {
        return ClientConstants.getFallbackModel().func_177555_b();
    }

    public boolean func_177556_c() {
        return ClientConstants.getFallbackModel().func_177556_c();
    }

    public boolean func_230044_c_() {
        return ClientConstants.getFallbackModel().func_230044_c_();
    }

    public boolean func_188618_c() {
        return ClientConstants.getFallbackModel().func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return ClientConstants.getFallbackModel().func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ClientConstants.getFallbackModel().func_188617_f();
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        if (data.hasProperty(POSITIVE_BLOCK) && data.getData(POSITIVE_BLOCK) != null && ((IBlockInfo)data.getData(POSITIVE_BLOCK)).getBlockState() != null) {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(((IBlockInfo)data.getData(POSITIVE_BLOCK)).getBlockState()).getParticleTexture((IModelData)EmptyModelData.INSTANCE);
        }
        return ClientConstants.getFallbackModel().getParticleTexture((IModelData)EmptyModelData.INSTANCE);
    }

    protected boolean shouldCull(BlockState state, BlockState neighbour, Direction direction) {
        if (state == null || neighbour == null) {
            return false;
        }
        return state.func_200017_a(neighbour, direction) || !ClientUtils.isTransparent(state) && !ClientUtils.isTransparent(neighbour);
    }

    protected boolean useDoubleSlabModel(BlockState state1, BlockState state2) {
        return state1.func_177230_c() == state2.func_177230_c() && DSConfig.CLIENT.useDoubleSlabModel(state1.func_177230_c());
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (extraData.hasProperty(POSITIVE_BLOCK) && extraData.hasProperty(NEGATIVE_BLOCK)) {
            SlabCacheKey key = new SlabCacheKey((IBlockInfo)extraData.getData(POSITIVE_BLOCK), (IBlockInfo)extraData.getData(NEGATIVE_BLOCK), side, rand, (List)extraData.getData(CULL_DIRECTIONS), extraData, state);
            try {
                return this.getQuads(key);
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                DoubleSlabs.LOGGER.debug("Caught error when getting quads for key {}", (Object)key);
                DoubleSlabs.LOGGER.catching(Level.DEBUG, e);
            }
        } else if (MinecraftForgeClient.getRenderLayer() == null) {
            SlabCacheKey key = new SlabCacheKey(null, null, side, rand, null, extraData, state);
            try {
                return (List)this.cache.get((Object)key, () -> this.getQuads(key));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                DoubleSlabs.LOGGER.debug("Caught error when getting quads for key {}", (Object)key);
                DoubleSlabs.LOGGER.catching(Level.DEBUG, e);
            }
        }
        return ClientConstants.getFallbackModel().getQuads(state, side, rand, extraData);
    }

    protected abstract Block getBlock();

    protected abstract List<BakedQuad> getQuads(SlabCacheKey var1);

    @Nonnull
    public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        ArrayList<CullInfo> cullDirections = new ArrayList<CullInfo>();
        for (Direction direction : Direction.values()) {
            TileEntity tileEntity;
            BlockPos otherPos = pos.func_177972_a(direction);
            BlockState otherState = world.func_180495_p(otherPos);
            if (!(otherState.func_177230_c() instanceof DynamicSlabBlock) || otherState.func_177230_c() != this.getBlock() || !((tileEntity = world.func_175625_s(otherPos)) instanceof SlabTileEntity)) continue;
            SlabTileEntity tile = (SlabTileEntity)tileEntity;
            cullDirections.add(new CullInfo(tile.getPositiveBlockInfo(), tile.getNegativeBlockInfo(), state, otherState, direction));
        }
        tileData.setData(CULL_DIRECTIONS, cullDirections);
        return tileData;
    }
}

