/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.client.util.CacheKey;
import cjminecraft.doubleslabs.client.util.ClientUtils;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.logging.log4j.Level;

public class RaisedCampfireBakedModel
implements IDynamicBakedModel {
    private final Cache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().maximumSize(8L).build();
    private IBakedModel baseModel;
    private final Map<BlockState, IBakedModel> models = new HashMap<BlockState, IBakedModel>();

    public void addModel(IBakedModel model, BlockState state) {
        if (this.models.size() == 0) {
            this.baseModel = model;
        }
        this.models.put(state, model);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (state == null) {
            return this.baseModel.getQuads(null, side, rand, extraData);
        }
        try {
            CacheKey cacheKey = new CacheKey(state, side, rand, extraData);
            if (RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)cacheKey.getRenderLayer()) || cacheKey.getRenderLayer() == null) {
                return (List)this.cache.get((Object)cacheKey, () -> this.models.get(cacheKey.getState()).getQuads(cacheKey.getState(), cacheKey.getSide(), cacheKey.getRandom(), cacheKey.getModelData()).stream().map(quad -> new BakedQuad(ClientUtils.offsetY(quad.func_178209_a(), 0.5f), quad.func_178212_b() ? quad.func_178211_c() : -1, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting())).collect(Collectors.toList()));
            }
            return new ArrayList<BakedQuad>();
        }
        catch (ExecutionException e) {
            DoubleSlabs.LOGGER.debug("Caught error when getting quads for key {}", (Object)state);
            DoubleSlabs.LOGGER.catching(Level.DEBUG, (Throwable)e);
            return this.baseModel.getQuads(state, side, rand, extraData);
        }
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.baseModel.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.baseModel.func_188617_f();
    }
}

