/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.client.util.ClientUtils;
import cjminecraft.doubleslabs.client.util.CullInfo;
import cjminecraft.doubleslabs.client.util.SlabCacheKey;
import cjminecraft.doubleslabs.client.util.vertex.VerticalSlabTransformer;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class VerticalSlabBakedModel
extends DynamicSlabBakedModel {
    public static final VerticalSlabBakedModel INSTANCE = new VerticalSlabBakedModel();
    public static final ModelProperty<Boolean> ROTATE_POSITIVE = new ModelProperty();
    public static final ModelProperty<Boolean> ROTATE_NEGATIVE = new ModelProperty();
    private final Map<BlockState, IBakedModel> models = new HashMap<BlockState, IBakedModel>();

    public void addModel(IBakedModel model, BlockState state) {
        this.models.put(state, model);
    }

    public IBakedModel getModel(BlockState state) {
        return this.models.get(state);
    }

    @Override
    protected Block getBlock() {
        return (Block)DSBlocks.VERTICAL_SLAB.get();
    }

    private List<BakedQuad> getQuadsForState(SlabCacheKey cache, boolean positive) {
        boolean rotate;
        BlockState state;
        BlockState blockState = state = positive ? cache.getPositiveBlockInfo().getBlockState() : cache.getNegativeBlockInfo().getBlockState();
        if (state == null) {
            return new ArrayList<BakedQuad>();
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        EmptyModelData tileData = positive ? (cache.getPositiveBlockInfo().getTileEntity() != null ? cache.getPositiveBlockInfo().getTileEntity().getModelData() : EmptyModelData.INSTANCE) : (cache.getNegativeBlockInfo().getTileEntity() != null ? cache.getNegativeBlockInfo().getTileEntity().getModelData() : EmptyModelData.INSTANCE);
        IModelData modelData = model.getModelData((ILightReader)(positive ? cache.getPositiveBlockInfo().getWorld() : cache.getNegativeBlockInfo().getWorld()), cache.getPositiveBlockInfo().getPos(), state, (IModelData)tileData);
        ModelProperty<Boolean> property = positive ? ROTATE_POSITIVE : ROTATE_NEGATIVE;
        boolean bl = rotate = cache.getModelData().hasProperty(property) && cache.getModelData().getData(property) != null ? (Boolean)cache.getModelData().getData(property) : true;
        if (!rotate) {
            return new ArrayList<BakedQuad>(model.getQuads(state, cache.getSide(), cache.getRandom(), modelData));
        }
        Direction direction = (Direction)cache.getState().func_177229_b((IProperty)VerticalSlabBlock.FACING);
        Direction side = ClientUtils.rotateFace(cache.getSide(), direction);
        List quads = model.getQuads(state, side, cache.getRandom(), modelData);
        if (DSConfig.CLIENT.useLazyModel(state.func_177230_c())) {
            if (quads.size() == 0) {
                return new ArrayList<BakedQuad>();
            }
            BlockState baseState = positive ? cache.getState() : (BlockState)cache.getState().func_206870_a((IProperty)VerticalSlabBlock.FACING, (Comparable)direction.func_176734_d());
            baseState = (BlockState)baseState.func_206870_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(false));
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).func_187508_a();
            return this.models.get(baseState).getQuads(baseState, cache.getSide(), cache.getRandom(), (IModelData)EmptyModelData.INSTANCE).stream().map(quad -> new BakedQuad(ClientUtils.changeQuadUVs(quad.func_178209_a(), quad.func_187508_a(), sprite), quad.func_178212_b() ? quad.func_178211_c() + (positive ? 1000 : 0) : -1, quad.func_178210_d(), sprite, quad.shouldApplyDiffuseLighting())).collect(Collectors.toList());
        }
        if (ClientUtils.areShadersEnabled()) {
            VerticalSlabTransformer transformer = new VerticalSlabTransformer(direction, cache.getSide(), positive);
            return transformer.processMany(quads);
        }
        return quads.stream().map(quad -> {
            int[] vertexData = ClientUtils.rotateVertexData(quad.func_178209_a(), direction, cache.getSide());
            return new BakedQuad(vertexData, quad.func_178212_b() ? quad.func_178211_c() + (positive ? 1000 : 0) : -1, FaceBakery.func_178410_a((int[])vertexData), quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
        }).collect(Collectors.toList());
    }

    @Override
    protected List<BakedQuad> getQuads(SlabCacheKey cache) {
        Direction otherDirection;
        IHorizontalSlabSupport horizontalSlabSupport;
        if (!cache.isValid()) {
            IBakedModel model = this.models.getOrDefault(cache.getState(), null);
            if (model != null) {
                return model.getQuads(cache.getState(), cache.getSide(), cache.getRandom(), (IModelData)EmptyModelData.INSTANCE);
            }
            return ClientConstants.getFallbackModel().getQuads(cache.getState(), cache.getSide(), cache.getRandom(), (IModelData)EmptyModelData.INSTANCE);
        }
        List<Object> quads = new ArrayList<BakedQuad>();
        boolean positiveTransparent = cache.getPositiveBlockInfo().getBlockState() == null || ClientUtils.isTransparent(cache.getPositiveBlockInfo().getBlockState());
        boolean negativeTransparent = cache.getNegativeBlockInfo().getBlockState() == null || ClientUtils.isTransparent(cache.getNegativeBlockInfo().getBlockState());
        boolean shouldCull = cache.getPositiveBlockInfo().getBlockState() != null && cache.getNegativeBlockInfo().getBlockState() != null && DSConfig.CLIENT.shouldCull(cache.getPositiveBlockInfo().getBlockState().func_177230_c()) && DSConfig.CLIENT.shouldCull(cache.getNegativeBlockInfo().getBlockState().func_177230_c()) && (!positiveTransparent || !negativeTransparent || cache.getPositiveBlockInfo().getBlockState().func_177230_c() == cache.getNegativeBlockInfo().getBlockState().func_177230_c() && cache.getPositiveBlockInfo().getBlockState().func_177230_c() == cache.getNegativeBlockInfo().getBlockState().func_177230_c());
        Direction direction = (Direction)cache.getState().func_177229_b((IProperty)VerticalSlabBlock.FACING);
        if (cache.getPositiveBlockInfo().getBlockState() != null && cache.getNegativeBlockInfo().getBlockState() != null && this.useDoubleSlabModel(cache.getPositiveBlockInfo().getBlockState(), cache.getNegativeBlockInfo().getBlockState()) && (horizontalSlabSupport = SlabSupport.isHorizontalSlab((IBlockReader)cache.getPositiveBlockInfo().getWorld(), cache.getPositiveBlockInfo().getPos(), cache.getPositiveBlockInfo().getBlockState())) != null && horizontalSlabSupport.useDoubleSlabModel(cache.getPositiveBlockInfo().getBlockState())) {
            BlockState state = horizontalSlabSupport.getStateForHalf(cache.getPositiveBlockInfo().getWorld(), cache.getPositiveBlockInfo().getPos(), cache.getPositiveBlockInfo().getBlockState(), SlabType.DOUBLE);
            if (RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)cache.getRenderLayer()) || cache.getRenderLayer() == null) {
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
                Direction side = ClientUtils.rotateFace(cache.getSide(), direction);
                if (DSConfig.CLIENT.useLazyModel(state.func_177230_c())) {
                    quads = new ArrayList(model.getQuads(state, cache.getSide(), cache.getRandom(), (IModelData)EmptyModelData.INSTANCE));
                } else if (!ClientUtils.isOptiFineInstalled()) {
                    quads = model.getQuads(state, side, cache.getRandom(), (IModelData)EmptyModelData.INSTANCE).stream().map(quad -> {
                        int[] vertexData = ClientUtils.rotateVertexData(quad.func_178209_a(), direction, cache.getSide());
                        return new BakedQuad(vertexData, quad.func_178212_b() ? quad.func_178211_c() : -1, FaceBakery.func_178410_a((int[])vertexData), quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
                    }).collect(Collectors.toList());
                } else {
                    VerticalSlabTransformer transformer = new VerticalSlabTransformer(direction, cache.getSide(), false);
                    quads = transformer.processMany(model.getQuads(state, ClientUtils.rotateFace(cache.getSide(), direction), cache.getRandom(), (IModelData)EmptyModelData.INSTANCE));
                }
                if (cache.getSide() != null) {
                    for (CullInfo cullInfo : cache.getCullInfo()) {
                        if (((Boolean)cullInfo.getOtherState().func_177229_b((IProperty)VerticalSlabBlock.DOUBLE)).booleanValue() && cullInfo.getPositiveBlockInfo().getBlockState() != null && cullInfo.getNegativeBlockInfo().getBlockState() != null && this.useDoubleSlabModel(cullInfo.getPositiveBlockInfo().getBlockState(), cullInfo.getNegativeBlockInfo().getBlockState())) {
                            BlockState s;
                            IHorizontalSlabSupport support = SlabSupport.isHorizontalSlab((IBlockReader)cullInfo.getPositiveBlockInfo().getWorld(), cullInfo.getPositiveBlockInfo().getPos(), cullInfo.getPositiveBlockInfo().getBlockState());
                            if (support == null || !this.shouldCull(state, s = support.getStateForHalf(cullInfo.getPositiveBlockInfo().getWorld(), cullInfo.getPositiveBlockInfo().getPos(), cullInfo.getPositiveBlockInfo().getBlockState(), SlabType.DOUBLE), cullInfo.getDirection())) continue;
                            quads.removeIf(quad -> quad.func_178210_d() == cullInfo.getDirection());
                            continue;
                        }
                        if ((cullInfo.getOtherState().func_177229_b((IProperty)VerticalSlabBlock.FACING) != cullInfo.getDirection() || !this.shouldCull(state, cullInfo.getPositiveBlockInfo().getBlockState(), cullInfo.getDirection())) && !this.shouldCull(state, cullInfo.getNegativeBlockInfo().getBlockState(), cullInfo.getDirection())) continue;
                        quads.removeIf(quad -> quad.func_178210_d() == cullInfo.getDirection());
                    }
                }
                return quads;
            }
            return new ArrayList<BakedQuad>();
        }
        if (cache.getPositiveBlockInfo().getBlockState() != null && (RenderTypeLookup.canRenderInLayer((BlockState)cache.getPositiveBlockInfo().getBlockState(), (RenderType)cache.getRenderLayer()) || cache.getRenderLayer() == null)) {
            List<BakedQuad> positiveQuads = this.getQuadsForState(cache, true);
            if (shouldCull && (!negativeTransparent && !positiveTransparent || positiveTransparent && !negativeTransparent || positiveTransparent && negativeTransparent)) {
                positiveQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == direction.func_176734_d());
            }
            if (cache.getSide() != null) {
                for (CullInfo cullInfo : cache.getCullInfo()) {
                    otherDirection = (Direction)cullInfo.getOtherState().func_177229_b((IProperty)VerticalSlabBlock.FACING);
                    if (!((Boolean)cullInfo.getState().func_177229_b((IProperty)VerticalSlabBlock.DOUBLE)).booleanValue() && otherDirection.func_176740_k() != direction.func_176740_k()) continue;
                    boolean positive = direction == otherDirection && cullInfo.getDirection().func_176740_k() != direction.func_176740_k() || otherDirection.func_176740_k() != direction.func_176740_k() || direction == otherDirection.func_176734_d() && cullInfo.getDirection().func_176740_k() == direction.func_176740_k();
                    if (!this.shouldCull(cache.getPositiveBlockInfo().getBlockState(), positive ? cullInfo.getPositiveBlockInfo().getBlockState() : cullInfo.getNegativeBlockInfo().getBlockState(), cullInfo.getDirection())) continue;
                    positiveQuads.removeIf(quad -> quad.func_178210_d() == cullInfo.getDirection());
                }
            }
            quads.addAll(positiveQuads);
        }
        if (cache.getNegativeBlockInfo().getBlockState() != null && (RenderTypeLookup.canRenderInLayer((BlockState)cache.getNegativeBlockInfo().getBlockState(), (RenderType)cache.getRenderLayer()) || cache.getRenderLayer() == null)) {
            List<BakedQuad> negativeQuads = this.getQuadsForState(cache, false);
            if (shouldCull && (!positiveTransparent && !negativeTransparent || negativeTransparent && !positiveTransparent || positiveTransparent && negativeTransparent)) {
                negativeQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == direction);
            }
            if (cache.getSide() != null) {
                for (CullInfo cullInfo : cache.getCullInfo()) {
                    otherDirection = (Direction)cullInfo.getOtherState().func_177229_b((IProperty)VerticalSlabBlock.FACING);
                    if (!((Boolean)cullInfo.getState().func_177229_b((IProperty)VerticalSlabBlock.DOUBLE)).booleanValue() && otherDirection.func_176740_k() != direction.func_176740_k()) continue;
                    boolean negative = direction == otherDirection && cullInfo.getDirection().func_176740_k() != direction.func_176740_k() || otherDirection.func_176740_k() != direction.func_176740_k() || direction == otherDirection.func_176734_d() && cullInfo.getDirection().func_176740_k() == direction.func_176740_k();
                    if (!this.shouldCull(cache.getNegativeBlockInfo().getBlockState(), negative ? cullInfo.getNegativeBlockInfo().getBlockState() : cullInfo.getPositiveBlockInfo().getBlockState(), cullInfo.getDirection())) continue;
                    negativeQuads.removeIf(quad -> quad.func_178210_d() == cullInfo.getDirection());
                }
            }
            quads.addAll(negativeQuads);
        }
        return quads;
    }

    private boolean rotateModel(IModelData modelData, ModelProperty<IBlockInfo> property, IBlockReader world, BlockPos pos) {
        IVerticalSlabSupport support;
        IBlockInfo blockInfo;
        if (modelData.hasProperty(property) && (blockInfo = (IBlockInfo)modelData.getData(property)) != null && blockInfo.getBlockState() != null && (support = SlabSupport.getVerticalSlabSupport(world, pos, blockInfo.getBlockState())) != null) {
            return support.rotateModel((IBlockReader)blockInfo.getWorld(), pos, blockInfo.getBlockState());
        }
        return true;
    }

    @Override
    @Nonnull
    public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        IModelData modelData = super.getModelData(world, pos, state, tileData);
        modelData.setData(ROTATE_POSITIVE, (Object)this.rotateModel(modelData, (ModelProperty<IBlockInfo>)POSITIVE_BLOCK, (IBlockReader)world, pos));
        modelData.setData(ROTATE_NEGATIVE, (Object)this.rotateModel(modelData, (ModelProperty<IBlockInfo>)NEGATIVE_BLOCK, (IBlockReader)world, pos));
        return modelData;
    }
}

