/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.client.util.ClientUtils;
import cjminecraft.doubleslabs.client.util.VerticalSlabItemCacheKey;
import cjminecraft.doubleslabs.client.util.vertex.VerticalSlabTransformer;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.items.VerticalSlabItem;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.logging.log4j.Level;

public class VerticalSlabItemBakedModel
implements IBakedModel {
    private static final Cache<VerticalSlabItemCacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build();
    private static final QuadTransformer TRANSFORMER_2D = new QuadTransformer(new TransformationMatrix(new Vector3f(0.0f, 1.0f, 0.0f), Vector3f.field_229182_e_.func_229187_a_(90.0f), null, null));
    public static VerticalSlabItemBakedModel INSTANCE;
    private final ItemStack stack;
    private final IBakedModel baseModel;

    public IBakedModel getBaseModel() {
        return this.baseModel;
    }

    public VerticalSlabItemBakedModel(IBakedModel baseModel) {
        this(baseModel, ItemStack.field_190927_a);
    }

    public VerticalSlabItemBakedModel(IBakedModel baseModel, ItemStack stack) {
        this.baseModel = baseModel;
        this.stack = stack;
    }

    private Block getBlock() {
        return this.stack.func_77973_b() instanceof BlockItem ? ((BlockItem)this.stack.func_77973_b()).func_179223_d() : Blocks.field_150350_a;
    }

    private List<BakedQuad> getQuads(@Nullable Direction side, Random rand) {
        if (this.func_177556_c()) {
            Direction rotatedSide = ClientUtils.rotateFace(side, Direction.SOUTH);
            List quads = this.baseModel.func_200117_a(null, rotatedSide, rand);
            if (DSConfig.CLIENT.useLazyModel(this.getBlock())) {
                if (quads.size() == 0) {
                    return new ArrayList<BakedQuad>();
                }
                BlockState baseState = (BlockState)((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).func_176223_P().func_206870_a((IProperty)VerticalSlabBlock.FACING, (Comparable)Direction.SOUTH);
                TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).func_187508_a();
                return VerticalSlabBakedModel.INSTANCE.getModel(baseState).getQuads(baseState, side, rand, (IModelData)EmptyModelData.INSTANCE).stream().map(quad -> new BakedQuad(ClientUtils.changeQuadUVs(quad.func_178209_a(), quad.func_187508_a(), sprite), quad.func_178212_b() ? quad.func_178211_c() : -1, quad.func_178210_d(), sprite, quad.shouldApplyDiffuseLighting())).collect(Collectors.toList());
            }
            if (ClientUtils.areShadersEnabled()) {
                VerticalSlabTransformer transformer = new VerticalSlabTransformer(Direction.SOUTH, side, true);
                return transformer.processMany(quads);
            }
            return quads.stream().map(quad -> {
                int[] vertexData = ClientUtils.rotateVertexData(quad.func_178209_a(), Direction.SOUTH, side);
                return new BakedQuad(vertexData, quad.func_178212_b() ? quad.func_178211_c() : -1, FaceBakery.func_178410_a((int[])vertexData), quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
            }).collect(Collectors.toList());
        }
        return TRANSFORMER_2D.processMany(this.baseModel.func_200117_a(null, side, rand));
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        VerticalSlabItemCacheKey key = new VerticalSlabItemCacheKey(side, rand, this.stack, this.baseModel);
        try {
            return (List)cache.get((Object)key, () -> this.getQuads(side, rand));
        }
        catch (ExecutionException e) {
            DoubleSlabs.LOGGER.debug("Caught error when getting quads for key {}", (Object)key);
            DoubleSlabs.LOGGER.catching(Level.DEBUG, (Throwable)e);
            return ClientConstants.getFallbackModel().func_200117_a(state, side, rand);
        }
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.baseModel.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        if (this == INSTANCE) {
            return new DynamicItemOverrideList();
        }
        return ItemOverrideList.field_188022_a;
    }

    private static class DynamicItemOverrideList
    extends ItemOverrideList {
        private HashMap<ItemStack, IBakedModel> cache = new HashMap();

        private DynamicItemOverrideList() {
        }

        @Nullable
        public IBakedModel func_209581_a(IBakedModel parent, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            ItemStack slabStack = VerticalSlabItem.getStack(stack);
            if (this.cache.containsKey(slabStack)) {
                return this.cache.get(slabStack);
            }
            VerticalSlabItemBakedModel model = new VerticalSlabItemBakedModel(Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(slabStack), slabStack);
            this.cache.put(slabStack, model);
            return model;
        }
    }
}

