/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.proxy;

import cjminecraft.doubleslabs.client.gui.WrappedScreen;
import cjminecraft.doubleslabs.client.model.DoubleSlabBakedModel;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.client.model.RaisedCampfireBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabItemBakedModel;
import cjminecraft.doubleslabs.client.render.RaisedCampfireTileEntityRenderer;
import cjminecraft.doubleslabs.client.render.SlabTileEntityRenderer;
import cjminecraft.doubleslabs.client.util.ClientUtils;
import cjminecraft.doubleslabs.client.util.vertex.VerticalSlabTransformer;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.config.ConfigEventsHandler;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.init.DSContainers;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.init.DSKeyBindings;
import cjminecraft.doubleslabs.common.init.DSTiles;
import cjminecraft.doubleslabs.common.proxy.IProxy;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientProxy
implements IProxy {
    @Override
    public void addListeners(IEventBus mod, IEventBus forge) {
        mod.addListener(this::clientSetup);
        mod.addListener(this::registerBlockColours);
        mod.addListener(this::bakeModels);
        mod.addListener(ConfigEventsHandler::onFileChange);
    }

    private void replaceModel(IBakedModel model, Block block, BiConsumer<IBakedModel, BlockState> perModel, Map<ResourceLocation, IBakedModel> registry) {
        for (BlockState state : block.func_176194_O().func_177619_a()) {
            ModelResourceLocation variantResourceLocation = BlockModelShapes.func_209554_c((BlockState)state);
            IBakedModel existingModel = registry.get(variantResourceLocation);
            if (existingModel == null) {
                DoubleSlabs.LOGGER.warn("Did not find the expected vanilla baked model(s) for the block in registry");
                continue;
            }
            if (existingModel instanceof DynamicSlabBakedModel) {
                DoubleSlabs.LOGGER.warn("Tried to replace model twice");
                continue;
            }
            perModel.accept(existingModel, state);
            registry.put((ResourceLocation)variantResourceLocation, model);
        }
    }

    private void bakeModels(ModelBakeEvent event) {
        VerticalSlabTransformer.reload();
        this.replaceModel((IBakedModel)new DoubleSlabBakedModel(), (Block)DSBlocks.DOUBLE_SLAB.get(), (model, state) -> {}, event.getModelRegistry());
        this.replaceModel((IBakedModel)VerticalSlabBakedModel.INSTANCE, (Block)DSBlocks.VERTICAL_SLAB.get(), VerticalSlabBakedModel.INSTANCE::addModel, event.getModelRegistry());
        RaisedCampfireBakedModel campfireBakedModel = new RaisedCampfireBakedModel();
        this.replaceModel((IBakedModel)campfireBakedModel, (Block)DSBlocks.RAISED_CAMPFIRE.get(), campfireBakedModel::addModel, event.getModelRegistry());
        ModelResourceLocation verticalSlabItemResourceLocation = new ModelResourceLocation(DSItems.VERTICAL_SLAB.getId(), "inventory");
        VerticalSlabItemBakedModel.INSTANCE = new VerticalSlabItemBakedModel((IBakedModel)event.getModelRegistry().get(verticalSlabItemResourceLocation));
        event.getModelRegistry().put(verticalSlabItemResourceLocation, VerticalSlabItemBakedModel.INSTANCE);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DSKeyBindings.register();
        RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.DOUBLE_SLAB.get()), layer -> true);
        RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.VERTICAL_SLAB.get()), layer -> true);
        RenderTypeLookup.setRenderLayer((Block)((Block)DSBlocks.RAISED_CAMPFIRE.get()), (RenderType)RenderType.func_228643_e_());
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)DSTiles.DYNAMIC_SLAB.get()), SlabTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)DSTiles.CAMPFIRE.get()), RaisedCampfireTileEntityRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)DSContainers.WRAPPED_CONTAINER.get()), WrappedScreen::new);
        ClientUtils.checkOptiFineInstalled();
    }

    private void registerBlockColours(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a(((DynamicSlabBlock)DSBlocks.DOUBLE_SLAB.get()).getBlockColor(), new Block[]{(Block)DSBlocks.DOUBLE_SLAB.get()});
        event.getBlockColors().func_186722_a(((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).getBlockColor(), new Block[]{(Block)DSBlocks.VERTICAL_SLAB.get()});
    }
}

