/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.util;

import java.util.Objects;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Direction;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;

public class CacheKey {
    protected final BlockState state;
    protected final Direction side;
    protected final Random random;
    protected final IModelData modelData;
    protected final RenderType renderLayer;

    public CacheKey(BlockState state, Direction side, Random random, IModelData modelData) {
        this.state = state;
        this.side = side;
        this.random = random;
        this.modelData = modelData;
        this.renderLayer = MinecraftForgeClient.getRenderLayer();
    }

    public BlockState getState() {
        return this.state;
    }

    public Direction getSide() {
        return this.side;
    }

    public Random getRandom() {
        return this.random;
    }

    public IModelData getModelData() {
        return this.modelData;
    }

    public RenderType getRenderLayer() {
        return this.renderLayer;
    }

    public String toString() {
        return "CacheKey{state=" + this.state + ", side=" + this.side + ", random=" + this.random + ", modelData=" + this.modelData + ", renderLayer=" + this.renderLayer + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        return Objects.equals(this.state, cacheKey.state) && this.side == cacheKey.side && this.random.equals(cacheKey.random) && this.modelData.equals(cacheKey.modelData) && Objects.equals(this.renderLayer, cacheKey.renderLayer);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.side, this.random, this.modelData, this.renderLayer);
    }
}

