/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.util;

import cjminecraft.doubleslabs.common.DoubleSlabs;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.FaceDirection;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;

public class ClientUtils {
    private static final Quaternion ROTATE_X_90 = Vector3f.field_229179_b_.func_229187_a_(90.0f);
    private static final Quaternion ROTATE_Z_180 = Vector3f.field_229183_f_.func_229187_a_(180.0f);
    private static Class<?> OPTIFINE_CONFIG;
    private static Method OPTIFINE_IS_SHADERS_METHOD;
    private static final HashMap<Pair<Direction, Direction>, Consumer<Vector4f>> DIRECTION_TO_TRANSFORMATION;
    private static final HashMap<Direction, Quaternion> DIRECTION_TO_ANGLE;

    public static boolean isTransparent(BlockState state) {
        return !state.func_185904_a().func_76218_k() || !state.func_200132_m();
    }

    public static void checkOptiFineInstalled() {
        try {
            OPTIFINE_CONFIG = Class.forName("net.optifine.Config");
            OPTIFINE_IS_SHADERS_METHOD = OPTIFINE_CONFIG.getMethod("isShaders", new Class[0]);
            DoubleSlabs.LOGGER.info("Detected OptiFine is installed. Applying fixes");
        }
        catch (ClassNotFoundException | NoSuchMethodException ignored) {
            OPTIFINE_CONFIG = null;
            OPTIFINE_IS_SHADERS_METHOD = null;
        }
    }

    public static boolean isOptiFineInstalled() {
        return OPTIFINE_CONFIG != null;
    }

    public static boolean areShadersEnabled() {
        try {
            return ClientUtils.isOptiFineInstalled() && (Boolean)OPTIFINE_IS_SHADERS_METHOD.invoke(null, new Object[0]) != false;
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return false;
        }
    }

    public static Consumer<Vector4f> getVertexTransformation(Direction direction, @Nullable Direction side) {
        return DIRECTION_TO_TRANSFORMATION.getOrDefault(Pair.of((Object)direction, (Object)side), vector -> {});
    }

    private static float[] getPositions(Vector3f pos1, Vector3f pos2) {
        float[] positions = new float[Direction.values().length];
        positions[FaceDirection.Constants.field_179176_f] = pos1.func_195899_a();
        positions[FaceDirection.Constants.field_179178_e] = pos1.func_195900_b();
        positions[FaceDirection.Constants.field_179177_d] = pos1.func_195902_c();
        positions[FaceDirection.Constants.field_179180_c] = pos2.func_195899_a();
        positions[FaceDirection.Constants.field_179179_b] = pos2.func_195900_b();
        positions[FaceDirection.Constants.field_179181_a] = pos2.func_195902_c();
        return positions;
    }

    private static boolean approximatelyEqual(float a, float b) {
        if (a == b) {
            return true;
        }
        float diff = Math.abs(a - b);
        return (double)diff < 0.01;
    }

    public static int[] rotateVertexData(int[] vertexData, Direction direction, @Nullable Direction side) {
        int[] data = new int[vertexData.length];
        float minX = 1.0f;
        float minY = 1.0f;
        float minZ = 1.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        float maxZ = 0.0f;
        for (int i = 0; i < vertexData.length / 8; ++i) {
            float x = Float.intBitsToFloat(vertexData[i * 8]) - 0.5f;
            float y = Float.intBitsToFloat(vertexData[i * 8 + 1]) - 0.5f;
            float z = Float.intBitsToFloat(vertexData[i * 8 + 2]) - 0.5f;
            Vector4f vertex = new Vector4f(x, y, z, 0.0f);
            ClientUtils.getVertexTransformation(direction, side).accept(vertex);
            float transformedX = vertex.func_195910_a() + 0.5f;
            float transformedY = vertex.func_195913_b() + 0.5f;
            float transformedZ = vertex.func_195914_c() + 0.5f;
            if (transformedX < minX) {
                minX = transformedX;
            } else if (transformedX > maxX) {
                maxX = transformedX;
            }
            if (transformedY < minY) {
                minY = transformedY;
            } else if (transformedY > maxY) {
                maxY = transformedY;
            }
            if (transformedZ < minZ) {
                minZ = transformedZ;
            } else if (transformedZ > maxZ) {
                maxZ = transformedZ;
            }
            data[i * 8] = Float.floatToIntBits(transformedX);
            data[i * 8 + 1] = Float.floatToIntBits(transformedY);
            data[i * 8 + 2] = Float.floatToIntBits(transformedZ);
            data[i * 8 + 3] = vertexData[i * 8 + 3];
            data[i * 8 + 4] = vertexData[i * 8 + 4];
            data[i * 8 + 5] = vertexData[i * 8 + 5];
            data[i * 8 + 6] = vertexData[i * 8 + 6];
            data[i * 8 + 7] = vertexData[i * 8 + 7];
        }
        if (side != null) {
            int[] finalData = new int[data.length];
            Vector3f from = new Vector3f(minX, minY, minZ);
            Vector3f to = new Vector3f(maxX, maxY, maxZ);
            float[] positions = ClientUtils.getPositions(from, to);
            for (int i = 0; i < 4; ++i) {
                FaceDirection faceDirection = FaceDirection.func_179027_a((Direction)side);
                FaceDirection.VertexInformation vertexInformation = faceDirection.func_179025_a(i);
                finalData[i * 8] = Float.floatToRawIntBits(positions[vertexInformation.field_179184_a]);
                finalData[i * 8 + 1] = Float.floatToRawIntBits(positions[vertexInformation.field_179182_b]);
                finalData[i * 8 + 2] = Float.floatToRawIntBits(positions[vertexInformation.field_179183_c]);
                int newIndex = -1;
                for (int j = 0; j < 4; ++j) {
                    if (!ClientUtils.approximatelyEqual(Float.intBitsToFloat(data[j * 8]), positions[vertexInformation.field_179184_a]) || !ClientUtils.approximatelyEqual(Float.intBitsToFloat(data[j * 8 + 1]), positions[vertexInformation.field_179182_b]) || !ClientUtils.approximatelyEqual(Float.intBitsToFloat(data[j * 8 + 2]), positions[vertexInformation.field_179183_c])) continue;
                    newIndex = j;
                }
                if (newIndex < 0) {
                    finalData[i * 8 + 3] = data[i * 8 + 3];
                    finalData[i * 8 + 4] = data[i * 8 + 4];
                    finalData[i * 8 + 5] = data[i * 8 + 5];
                    finalData[i * 8 + 6] = data[i * 8 + 6];
                    finalData[i * 8 + 7] = data[i * 8 + 7];
                    continue;
                }
                finalData[i * 8 + 3] = data[newIndex * 8 + 3];
                finalData[i * 8 + 4] = data[newIndex * 8 + 4];
                finalData[i * 8 + 5] = data[newIndex * 8 + 5];
                finalData[i * 8 + 6] = data[newIndex * 8 + 6];
                finalData[i * 8 + 7] = data[newIndex * 8 + 7];
            }
            ForgeHooksClient.fillNormal((int[])finalData, (Direction)FaceBakery.func_178410_a((int[])finalData));
            return finalData;
        }
        ForgeHooksClient.fillNormal((int[])data, (Direction)FaceBakery.func_178410_a((int[])data));
        return data;
    }

    public static int[] changeQuadUVs(int[] vertexData, TextureAtlasSprite originalSprite, TextureAtlasSprite newSprite) {
        int[] data = new int[vertexData.length];
        for (int i = 0; i < vertexData.length / 8; ++i) {
            data[i * 8] = vertexData[i * 8];
            data[i * 8 + 1] = vertexData[i * 8 + 1];
            data[i * 8 + 2] = vertexData[i * 8 + 2];
            data[i * 8 + 3] = vertexData[i * 8 + 3];
            data[i * 8 + 4] = Float.floatToIntBits(Float.intBitsToFloat(vertexData[i * 8 + 4]) - originalSprite.func_94209_e() + newSprite.func_94209_e());
            data[i * 8 + 5] = Float.floatToIntBits(Float.intBitsToFloat(vertexData[i * 8 + 5]) - originalSprite.func_94206_g() + newSprite.func_94206_g());
            data[i * 8 + 6] = vertexData[i * 8 + 6];
            data[i * 8 + 7] = vertexData[i * 8 + 7];
        }
        return data;
    }

    public static Direction rotateFace(Quaternion quaternion, Direction directionIn) {
        Vec3i vector3i = directionIn.func_176730_m();
        Vector4f vector4f = new Vector4f((float)vector3i.func_177958_n(), (float)vector3i.func_177956_o(), (float)vector3i.func_177952_p(), 0.0f);
        vector4f.func_195912_a(quaternion);
        return Direction.func_176737_a((float)vector4f.func_195910_a(), (float)vector4f.func_195913_b(), (float)vector4f.func_195914_c());
    }

    public static Direction rotateFace(Direction face, Direction verticalSlabDirection) {
        boolean zAxis;
        if (face == null) {
            return null;
        }
        Quaternion rotation = DIRECTION_TO_ANGLE.get(verticalSlabDirection);
        boolean negativeDirection = verticalSlabDirection.func_176743_c() == Direction.AxisDirection.NEGATIVE;
        boolean bl = zAxis = verticalSlabDirection.func_176740_k() == Direction.Axis.Z;
        if (face == verticalSlabDirection) {
            return Direction.DOWN;
        }
        if (face == verticalSlabDirection.func_176734_d()) {
            return Direction.UP;
        }
        if (face == Direction.DOWN) {
            return Direction.SOUTH;
        }
        if (face == Direction.UP) {
            return Direction.NORTH;
        }
        if (face.func_176740_k() == Direction.Axis.X && zAxis) {
            return negativeDirection ? face : face.func_176734_d();
        }
        if (face.func_176740_k() == Direction.Axis.Z && !zAxis) {
            return ClientUtils.rotateFace(rotation, face).func_176734_d();
        }
        return face;
    }

    public static int[] offsetY(int[] vertexData, float amount) {
        int[] data = new int[vertexData.length];
        for (int i = 0; i < vertexData.length / 8; ++i) {
            data[i * 8] = vertexData[i * 8];
            data[i * 8 + 1] = Float.floatToRawIntBits(Float.intBitsToFloat(vertexData[i * 8 + 1]) + amount);
            data[i * 8 + 2] = vertexData[i * 8 + 2];
            data[i * 8 + 3] = vertexData[i * 8 + 3];
            data[i * 8 + 4] = vertexData[i * 8 + 4];
            data[i * 8 + 5] = vertexData[i * 8 + 5];
            data[i * 8 + 6] = vertexData[i * 8 + 6];
            data[i * 8 + 7] = vertexData[i * 8 + 7];
        }
        return data;
    }

    static {
        DIRECTION_TO_TRANSFORMATION = new HashMap();
        DIRECTION_TO_ANGLE = new HashMap();
        DIRECTION_TO_ANGLE.put(Direction.NORTH, Vector3f.field_229181_d_.func_229187_a_(0.0f));
        DIRECTION_TO_ANGLE.put(Direction.SOUTH, Vector3f.field_229181_d_.func_229187_a_(180.0f));
        DIRECTION_TO_ANGLE.put(Direction.WEST, Vector3f.field_229181_d_.func_229187_a_(90.0f));
        DIRECTION_TO_ANGLE.put(Direction.EAST, Vector3f.field_229181_d_.func_229187_a_(270.0f));
        Arrays.stream(Direction.values()).filter(direction -> !direction.func_176740_k().func_200128_b()).forEach(direction -> {
            Quaternion angle = DIRECTION_TO_ANGLE.get(direction);
            DIRECTION_TO_TRANSFORMATION.put((Pair<Direction, Direction>)Pair.of((Object)direction, null), vector -> {
                vector.func_195912_a(ROTATE_X_90);
                vector.func_195912_a(angle);
            });
            Arrays.stream(Direction.values()).forEach(side -> DIRECTION_TO_TRANSFORMATION.put((Pair<Direction, Direction>)Pair.of((Object)direction, (Object)side), vector -> {
                vector.func_195912_a(ROTATE_X_90);
                if (side == direction) {
                    vector.func_195912_a(ROTATE_Z_180);
                }
                vector.func_195912_a(angle);
            }));
        });
    }
}

