/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.util;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.IStateContainer;
import cjminecraft.doubleslabs.client.util.CacheKey;
import cjminecraft.doubleslabs.client.util.CullInfo;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;

public class SlabCacheKey
extends CacheKey
implements IStateContainer {
    private final IBlockInfo positiveBlock;
    private final IBlockInfo negativeBlock;
    private final List<CullInfo> cullInfo;

    public SlabCacheKey(IBlockInfo positiveBlock, IBlockInfo negativeBlock, Direction side, Random random, List<CullInfo> cullInfo, IModelData modelData, BlockState state) {
        super(state, side, random, modelData);
        this.positiveBlock = positiveBlock;
        this.negativeBlock = negativeBlock;
        this.cullInfo = cullInfo;
    }

    @Override
    public IBlockInfo getPositiveBlockInfo() {
        return this.positiveBlock;
    }

    @Override
    public IBlockInfo getNegativeBlockInfo() {
        return this.negativeBlock;
    }

    public boolean isValid() {
        return this.positiveBlock != null && this.negativeBlock != null && this.cullInfo != null;
    }

    @Override
    public Direction getSide() {
        return this.side;
    }

    @Override
    public RenderType getRenderLayer() {
        return this.renderLayer;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    public List<CullInfo> getCullInfo() {
        return this.cullInfo;
    }

    @Override
    public IModelData getModelData() {
        return this.modelData;
    }

    @Override
    public String toString() {
        return "SlabCacheKey{positiveBlock=" + this.positiveBlock + ", negativeBlock=" + this.negativeBlock + ", cullInfo=" + this.cullInfo + ", state=" + this.state + ", side=" + this.side + ", random=" + this.random + ", modelData=" + this.modelData + ", renderLayer=" + this.renderLayer + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SlabCacheKey that = (SlabCacheKey)o;
        return Objects.equals(this.positiveBlock, that.positiveBlock) && Objects.equals(this.negativeBlock, that.negativeBlock) && Objects.equals(this.cullInfo, that.cullInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.positiveBlock, this.negativeBlock, this.cullInfo);
    }
}

