/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.util.vertex;

import cjminecraft.doubleslabs.client.util.ClientUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;

public class VerticalSlabTransformer {
    private static int POSITION = VerticalSlabTransformer.findPositionOffset(DefaultVertexFormats.field_176600_a);
    private static int NORMAL = VerticalSlabTransformer.findNormalOffset(DefaultVertexFormats.field_176600_a);
    private final Direction verticalSlabDirection;
    @Nullable
    private final Direction side;
    private final boolean positive;
    private final Consumer<Vector4f> transformation;

    public static void reload() {
        POSITION = VerticalSlabTransformer.findPositionOffset(DefaultVertexFormats.field_176600_a);
        NORMAL = VerticalSlabTransformer.findNormalOffset(DefaultVertexFormats.field_176600_a);
    }

    public VerticalSlabTransformer(Direction verticalSlabDirection, @Nullable Direction side, boolean positive) {
        this.verticalSlabDirection = verticalSlabDirection;
        this.side = side;
        this.positive = positive;
        this.transformation = ClientUtils.getVertexTransformation(this.verticalSlabDirection, this.side);
    }

    private static int getAtByteOffset(int[] inData, int offset) {
        int index = offset / 4;
        int lsb = inData[index];
        int shift = offset % 4 * 8;
        if (shift == 0) {
            return inData[index];
        }
        int msb = inData[index + 1];
        return lsb >>> shift | msb << 32 - shift;
    }

    private static void putAtByteOffset(int[] outData, int offset, int value) {
        int index = offset / 4;
        int shift = offset % 4 * 8;
        if (shift == 0) {
            outData[index] = value;
            return;
        }
        int lsbMask = -1 >>> 32 - shift;
        int msbMask = -1 << shift;
        outData[index] = outData[index] & lsbMask | value << shift;
        outData[index + 1] = outData[index + 1] & msbMask | value >>> 32 - shift;
    }

    private static int findPositionOffset(VertexFormat fmt) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < fmt.func_227894_c_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)fmt.func_227894_c_().get(index);
            if (el.func_177375_c() != VertexFormatElement.Usage.POSITION) continue;
            element = el;
            break;
        }
        if (index == fmt.func_227894_c_().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a POSITION attribute");
        }
        if (element.func_177367_b() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("Expected POSITION attribute to have data type FLOAT");
        }
        if (element.func_177368_f() < 3) {
            throw new RuntimeException("Expected POSITION attribute to have at least 3 dimensions");
        }
        return fmt.getOffset(index);
    }

    private static int findNormalOffset(VertexFormat fmt) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < fmt.func_227894_c_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)fmt.func_227894_c_().get(index);
            if (el.func_177375_c() != VertexFormatElement.Usage.NORMAL) continue;
            element = el;
            break;
        }
        if (index == fmt.func_227894_c_().size() || element == null) {
            throw new IllegalStateException("BLOCK format does not have normals?");
        }
        if (element.func_177367_b() != VertexFormatElement.Type.BYTE) {
            throw new RuntimeException("Expected NORMAL attribute to have data type BYTE");
        }
        if (element.func_177368_f() < 3) {
            throw new RuntimeException("Expected NORMAL attribute to have at least 3 dimensions");
        }
        return fmt.getOffset(index);
    }

    private void processVertices(int[] inData, int[] outData) {
        int offset;
        int i;
        int stride = DefaultVertexFormats.field_176600_a.func_177338_f();
        int count = inData.length * 4 / stride;
        for (i = 0; i < count; ++i) {
            offset = POSITION + i * stride;
            float x = Float.intBitsToFloat(VerticalSlabTransformer.getAtByteOffset(inData, offset)) - 0.5f;
            float y = Float.intBitsToFloat(VerticalSlabTransformer.getAtByteOffset(inData, offset + 4)) - 0.5f;
            float z = Float.intBitsToFloat(VerticalSlabTransformer.getAtByteOffset(inData, offset + 8)) - 0.5f;
            Vector4f pos = new Vector4f(x, y, z, 0.0f);
            this.transformation.accept(pos);
            VerticalSlabTransformer.putAtByteOffset(outData, offset, Float.floatToRawIntBits(pos.func_195910_a() + 0.5f));
            VerticalSlabTransformer.putAtByteOffset(outData, offset + 4, Float.floatToRawIntBits(pos.func_195913_b() + 0.5f));
            VerticalSlabTransformer.putAtByteOffset(outData, offset + 8, Float.floatToRawIntBits(pos.func_195914_c() + 0.5f));
        }
        for (i = 0; i < count; ++i) {
            offset = NORMAL + i * stride;
            int normalIn = VerticalSlabTransformer.getAtByteOffset(inData, offset);
            if (normalIn == 0) continue;
            float x = (float)((byte)(normalIn >> 24)) / 127.0f - 0.5f;
            float y = (float)((byte)(normalIn << 8 >> 24)) / 127.0f - 0.5f;
            float z = (float)((byte)(normalIn << 16 >> 24)) / 127.0f - 0.5f;
            Vector4f pos = new Vector4f(x, y, z, 0.0f);
            ClientUtils.getVertexTransformation(this.verticalSlabDirection, null).accept(pos);
            pos.func_195911_a(pos.func_195910_a() + 0.5f, pos.func_195913_b() + 0.5f, pos.func_195914_c() + 0.5f, 0.0f);
            pos.func_229374_e_();
            int normalOut = ((byte)(x / 127.0f) & 0xFF) << 24 | ((byte)(y / 127.0f) & 0xFF) << 16 | ((byte)(z / 127.0f) & 0xFF) << 8 | normalIn & 0xFF;
            VerticalSlabTransformer.putAtByteOffset(outData, offset, normalOut);
        }
    }

    private int getTintIndex(BakedQuad quad) {
        return quad.func_178212_b() ? (this.positive ? quad.func_178211_c() + 1000 : quad.func_178211_c()) : -1;
    }

    public BakedQuad processOne(BakedQuad input) {
        int[] inData = input.func_178209_a();
        int[] outData = Arrays.copyOf(inData, inData.length);
        this.processVertices(inData, outData);
        return new BakedQuad(outData, this.getTintIndex(input), FaceBakery.func_178410_a((int[])outData), input.func_187508_a(), input.shouldApplyDiffuseLighting());
    }

    public List<BakedQuad> processMany(List<BakedQuad> inputs) {
        if (inputs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList outputs = Lists.newArrayList();
        for (BakedQuad input : inputs) {
            int[] inData = input.func_178209_a();
            int[] outData = Arrays.copyOf(inData, inData.length);
            this.processVertices(inData, outData);
            outputs.add(new BakedQuad(outData, this.getTintIndex(input), FaceBakery.func_178410_a((int[])outData), input.func_187508_a(), input.shouldApplyDiffuseLighting()));
        }
        return outputs;
    }
}

