/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;

public class AnnotationUtil {
    public static final Predicate<Map<String, Object>> MODID_PREDICATE = data -> {
        String modid = data.getOrDefault("modid", "");
        return modid.length() == 0 || ModList.get().isLoaded(modid);
    };

    public static <T> List<T> getFieldInstances(Class<?> annotation, Class<T> instance) {
        Type type = Type.getType(annotation);
        List scanData = ModList.get().getAllScanData();
        ArrayList classAndFieldNames = new ArrayList();
        scanData.stream().map(datum -> datum.getAnnotations().stream().filter(a -> Objects.equals(a.getAnnotationType(), type)).map(a -> Pair.of((Object)a.getClassType().getClassName(), (Object)a.getMemberName())).collect(Collectors.toList())).forEach(classAndFieldNames::addAll);
        return classAndFieldNames.stream().map(pair -> {
            try {
                Class<?> clazz = Class.forName((String)pair.getLeft());
                Field field = clazz.getField((String)pair.getRight());
                if (!instance.isAssignableFrom(field.getType())) {
                    return null;
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field.get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> List<T> getClassInstances(Class<?> annotation, Class<T> instance) {
        return AnnotationUtil.getClassInstances(annotation, instance, data -> true);
    }

    public static <T> List<T> getClassInstances(Class<?> annotation, Class<T> instance, Predicate<Map<String, Object>> filter) {
        Type type = Type.getType(annotation);
        List scanData = ModList.get().getAllScanData();
        ArrayList classNames = new ArrayList();
        scanData.stream().map(datum -> datum.getAnnotations().stream().filter(a -> Objects.equals(a.getAnnotationType(), type) && filter.test(a.getAnnotationData())).map(ModFileScanData.AnnotationData::getMemberName).collect(Collectors.toList())).forEach(classNames::addAll);
        return classNames.stream().map(className -> {
            try {
                Class<?> clazz = Class.forName(className);
                if (!instance.isAssignableFrom(clazz)) {
                    return null;
                }
                Class instanceClass = clazz.asSubclass(instance);
                return instanceClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

