/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.blocks.poise.hive;

import endergeticexpansion.common.blocks.poise.hive.PuffbugHiveHangerBlock;
import endergeticexpansion.common.entities.puffbug.PuffBugEntity;
import endergeticexpansion.common.tileentities.PuffBugHiveTileEntity;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class PuffBugHiveBlock
extends Block {
    private static final VoxelShape HIVE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0));

    public PuffBugHiveBlock(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return HIVE_SHAPE;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        PuffBugHiveBlock.destroyBlock((IWorld)worldIn, pos, (LivingEntity)player);
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        PuffBugHiveBlock.destroyBlock((IWorld)worldIn, pos, (LivingEntity)player);
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        PuffBugHiveBlock.destroyBlock((IWorld)world, pos, explosion.func_94613_c());
        super.func_180652_a(world, pos, explosion);
    }

    public void func_220066_a(World world, BlockState state, BlockRayTraceResult hit, Entity projectile) {
        TileEntity tileEntity = world.func_175625_s(hit.func_216350_a());
        if (tileEntity instanceof PuffBugHiveTileEntity) {
            ((PuffBugHiveTileEntity)tileEntity).alertPuffBugs(null);
        }
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof PuffBugHiveTileEntity) {
            ((PuffBugHiveTileEntity)tileEntity).alertPuffBugs(null);
        }
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return !this.func_196260_a(state, (IWorldReader)world, currentPos) ? PuffBugHiveBlock.destroyBlock(world, currentPos, null) : state;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        int n = 0;
        Direction[] directionArray = context.func_196009_e();
        int n2 = directionArray.length;
        if (n < n2) {
            Direction enumfacing = directionArray[n];
            if (enumfacing == Direction.UP) {
                if (world.func_175623_d(blockpos.func_177977_b()) && Block.func_220056_d((BlockState)world.func_180495_p(blockpos.func_177984_a()), (IBlockReader)world, (BlockPos)blockpos, (Direction)Direction.DOWN)) {
                    AxisAlignedBB bb = new AxisAlignedBB(context.func_195995_a().func_177977_b());
                    List entities = context.func_195991_k().func_217357_a(Entity.class, bb);
                    if (entities.size() > 0) {
                        return null;
                    }
                    world.func_175656_a(blockpos.func_177977_b(), this.func_176223_P());
                    return ((PuffbugHiveHangerBlock)EEBlocks.HIVE_HANGER.get()).func_176223_P();
                }
                return this.func_176223_P();
            }
            return this.func_176223_P();
        }
        return null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState down = worldIn.func_180495_p(pos.func_177977_b());
        return (PuffBugHiveBlock.hasHanger(worldIn, pos) || down.func_200132_m() || down.func_177230_c() instanceof PuffBugHiveBlock) && super.func_196260_a(state, worldIn, pos);
    }

    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PuffBugHiveTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    private static boolean hasHanger(IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof PuffbugHiveHangerBlock;
    }

    private static BlockState destroyBlock(IWorld world, BlockPos pos, @Nullable LivingEntity breaker) {
        TileEntity tile;
        if (PuffBugHiveBlock.hasHanger((IWorldReader)world, pos)) {
            world.func_175655_b(pos.func_177984_a(), false);
        }
        if ((tile = world.func_175625_s(pos)) instanceof PuffBugHiveTileEntity) {
            PuffBugHiveTileEntity hive = (PuffBugHiveTileEntity)tile;
            if (breaker != null && PuffBugEntity.CAN_ANGER.test(breaker)) {
                hive.alertPuffBugs(breaker);
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }
}

