/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.bolloom;

import endergeticexpansion.common.entities.bolloom.BolloomBalloonEntity;
import endergeticexpansion.core.registry.EEEntities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BolloomKnotEntity
extends Entity {
    protected BlockPos hangingPosition;
    private static final DataParameter<Integer> BALLOONS_TIED = EntityDataManager.func_187226_a(BolloomKnotEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public BolloomKnotEntity(EntityType<? extends BolloomKnotEntity> entityTypeIn, World world) {
        super(entityTypeIn, world);
    }

    public BolloomKnotEntity(World world, BlockPos pos) {
        this((EntityType<? extends BolloomKnotEntity>)((EntityType)EEEntities.BOLLOOM_KNOT.get()), world);
        this.func_70107_b((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.9f, (float)pos.func_177952_p() + 0.5f);
        this.hangingPosition = pos;
        this.func_213317_d(Vec3d.field_186680_a);
        this.field_98038_p = true;
    }

    public BolloomKnotEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this((EntityType<? extends BolloomKnotEntity>)((EntityType)EEEntities.BOLLOOM_KNOT.get()), world);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (!this.field_70170_p.field_72995_K && this.func_130014_f_().isAreaLoaded(this.getHangingPos(), 1) && !this.field_70128_L && !this.onValidBlock()) {
            this.func_70106_y();
        }
        if (this.getBalloonsTied() <= 0) {
            this.func_70106_y();
        }
    }

    @Nullable
    public static BolloomKnotEntity getKnotForPosition(World worldIn, BlockPos pos) {
        for (BolloomKnotEntity entity : worldIn.func_217357_a(BolloomKnotEntity.class, new AxisAlignedBB(pos))) {
            if (!entity.getHangingPos().equals((Object)pos)) continue;
            return entity;
        }
        return null;
    }

    public static void createStartingKnot(World world, BlockPos pos, DyeColor balloonColor) {
        BolloomKnotEntity knot = new BolloomKnotEntity(world, pos);
        BolloomBalloonEntity balloon = new BolloomBalloonEntity(world, knot.func_110124_au(), pos, 0.0f);
        knot.setBalloonsTied(1);
        balloon.setColor(balloonColor);
        world.func_217376_c((Entity)knot);
        world.func_217376_c((Entity)balloon);
    }

    public void addBalloon(DyeColor balloonColor) {
        BolloomBalloonEntity balloon = new BolloomBalloonEntity(this.func_130014_f_(), this.func_110124_au(), this.getHangingPos(), 0.1f);
        balloon.setColor(balloonColor);
        this.field_70170_p.func_217376_c((Entity)balloon);
        this.setBalloonsTied(this.getBalloonsTied() + 1);
    }

    protected boolean onValidBlock() {
        return this.func_130014_f_().func_180495_p(this.hangingPosition).func_177230_c().func_203417_a(BlockTags.field_219748_G);
    }

    public boolean func_70067_L() {
        return true;
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        this.hangingPosition = new BlockPos(x, y, z);
        super.func_70107_b(x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 1024.0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BALLOONS_TIED, (Object)0);
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.hangingPosition = new BlockPos(nbt.func_74762_e("TileX"), nbt.func_74762_e("TileY"), nbt.func_74762_e("TileZ"));
        this.func_184212_Q().func_187227_b(BALLOONS_TIED, (Object)nbt.func_74762_e("Ballons_Tied"));
    }

    protected void func_213281_b(CompoundNBT nbt) {
        BlockPos blockpos = this.getHangingPos();
        nbt.func_74768_a("TileX", blockpos.func_177958_n());
        nbt.func_74768_a("TileY", blockpos.func_177956_o());
        nbt.func_74768_a("TileZ", blockpos.func_177952_p());
        nbt.func_74768_a("Ballons_Tied", ((Integer)this.func_184212_Q().func_187225_a(BALLOONS_TIED)).intValue());
    }

    public BlockPos getHangingPos() {
        return this.hangingPosition;
    }

    public void setBalloonsTied(int amount) {
        this.func_184212_Q().func_187227_b(BALLOONS_TIED, (Object)amount);
    }

    public int getBalloonsTied() {
        return (Integer)this.func_184212_Q().func_187225_a(BALLOONS_TIED);
    }

    public boolean hasMaxBalloons() {
        return (Integer)this.func_184212_Q().func_187225_a(BALLOONS_TIED) > 3;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

