/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.tiles;

import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import sonar.fluxnetworks.api.network.EnumConnectionType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.ITransferHandler;
import sonar.fluxnetworks.api.utils.Coord4D;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.core.FluxGuiStack;

public interface IFluxConnector
extends INetworkConnector {
    public CompoundNBT writeCustomNBT(CompoundNBT var1, NBTType var2);

    public void readCustomNBT(CompoundNBT var1, NBTType var2);

    public int getPriority();

    public int getActualPriority();

    public UUID getConnectionOwner();

    public EnumConnectionType getConnectionType();

    public boolean canAccess(PlayerEntity var1);

    public long getCurrentLimit();

    public long getActualLimit();

    default public long getMaxTransferLimit() {
        return Long.MAX_VALUE;
    }

    public boolean isActive();

    public boolean isChunkLoaded();

    public boolean isForcedLoading();

    public void connect(IFluxNetwork var1);

    public void disconnect(IFluxNetwork var1);

    public ITransferHandler getTransferHandler();

    public World getFluxWorld();

    public Coord4D getCoords();

    public int getFolderID();

    public String getCustomName();

    public boolean getDisableLimit();

    public boolean getSurgeMode();

    default public long getBuffer() {
        return this.getTransferHandler().getBuffer();
    }

    default public long getChange() {
        return this.getTransferHandler().getChange();
    }

    default public void setChunkLoaded(boolean chunkLoaded) {
    }

    default public ItemStack getDisplayStack() {
        switch (this.getConnectionType()) {
            case POINT: {
                return FluxGuiStack.FLUX_POINT;
            }
            case PLUG: {
                return FluxGuiStack.FLUX_PLUG;
            }
            case CONTROLLER: {
                return FluxGuiStack.FLUX_CONTROLLER;
            }
        }
        return ItemStack.field_190927_a;
    }
}

