/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.PageLabelButton;

public abstract class GuiTabPages<T>
extends GuiTabCore {
    public List<T> elements = Lists.newArrayList();
    protected List<T> current = Lists.newArrayList();
    protected SortType sortType = SortType.ID;
    protected PageLabelButton labelButton;
    private boolean init;
    public int page = 1;
    public int currentPages = 1;
    public int pages = 1;
    public int gridPerPage = 1;
    public int gridStartX = 0;
    public int gridStartY = 0;
    public int gridHeight = 0;
    public int elementHeight = 0;
    public int elementWidth = 0;

    public GuiTabPages(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        int y;
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.pages > 1) {
            this.labelButton.drawButton(this.minecraft, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
        int i = 0;
        for (T s : this.current) {
            y = this.gridStartY + this.gridHeight * i;
            this.renderElement(s, this.gridStartX, y);
            ++i;
        }
        i = 0;
        for (T s : this.current) {
            y = this.gridStartY + this.gridHeight * i;
            if (mouseX >= this.gridStartX + this.field_147003_i && mouseY >= y + this.field_147009_r && mouseX < this.gridStartX + this.elementWidth + this.field_147003_i && mouseY < y + this.elementHeight + this.field_147009_r) {
                this.renderElementTooltip(s, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
            ++i;
        }
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY);
    }

    public <T> T getHoveredElement(int mouseX, int mouseY) {
        if (this.current.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.currentPages; ++i) {
            int y = this.gridStartY + this.gridHeight * i;
            if (mouseX < this.gridStartX || mouseY < y || mouseX >= this.gridStartX + this.elementWidth || mouseY >= y + this.elementHeight || this.current.get(i) == null) continue;
            return this.current.get(i);
        }
        return null;
    }

    protected abstract void onElementClicked(T var1, int var2);

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedMain(mouseX, mouseY, mouseButton);
        T e = this.getHoveredElement((int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r);
        if (e != null) {
            this.onElementClicked(e, mouseButton);
            return true;
        }
        if (this.pages > 1 && this.labelButton.isMouseHovered(this.minecraft, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r) && this.page != this.labelButton.hoveredPage) {
            this.page = Math.max(this.labelButton.hoveredPage, 1);
            this.refreshCurrentPage();
            return true;
        }
        return false;
    }

    @Override
    public void init() {
        super.init();
        this.labelButton = new PageLabelButton(14, 157, this.page, this.pages, this.network.getSetting(NetworkSettings.NETWORK_COLOR), this.field_147003_i, this.field_147009_r);
    }

    @Override
    public boolean mouseScrolledMain(double mouseX, double mouseY, double scroll) {
        if (scroll == -1.0 && this.page < this.pages) {
            ++this.page;
            this.refreshCurrentPage();
            return true;
        }
        if (scroll == 1.0 && this.page > 1) {
            --this.page;
            this.refreshCurrentPage();
            return true;
        }
        return super.mouseScrolledMain(mouseX, mouseY, scroll);
    }

    public abstract void renderElement(T var1, int var2, int var3);

    public abstract void renderElementTooltip(T var1, int var2, int var3);

    protected void refreshPages(List<T> elements) {
        this.elements = elements;
        this.pages = (int)Math.ceil((double)elements.size() / (double)this.gridPerPage);
        this.sortGrids(this.sortType);
        if (!this.init) {
            this.refreshCurrentPage();
            this.init = true;
        } else {
            this.refreshCurrentPageInternal();
        }
    }

    protected void refreshCurrentPage() {
        this.refreshCurrentPageInternal();
        this.labelButton.refreshPages(this.page, this.pages);
    }

    protected void refreshCurrentPageInternal() {
        if (this.elements.size() == 0) {
            return;
        }
        this.current.clear();
        int a = (this.page - 1) * this.gridPerPage;
        int b = Math.min(this.elements.size(), this.page * this.gridPerPage);
        this.currentPages = b - a;
        for (int i = a; i < b; ++i) {
            this.current.add(this.elements.get(i));
        }
    }

    protected void sortGrids(SortType sortType) {
    }

    public static enum SortType {
        ID(FluxTranslate.SORTING_ID),
        NAME(FluxTranslate.SORTING_NAME);

        private FluxTranslate name;

        private SortType(FluxTranslate name) {
            this.name = name;
        }

        public String getTranslatedName() {
            return this.name.t();
        }
    }
}

