/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.gui.EnumNetworkColor;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabEditAbstract;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.GeneralPacket;
import sonar.fluxnetworks.common.network.GeneralPacketEnum;
import sonar.fluxnetworks.common.network.GeneralPacketHandler;

public class GuiTabSettings
extends GuiTabEditAbstract {
    public InvisibleButton redirectButton;
    public NormalButton apply;
    public NormalButton delete;
    public int deleteCount;

    public GuiTabSettings(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
        if (this.networkValid) {
            this.securityType = this.network.getSetting(NetworkSettings.NETWORK_SECURITY);
            this.energyType = this.network.getSetting(NetworkSettings.NETWORK_ENERGY);
        }
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_SETTING;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.getNavigationTab() == EnumNavigationTabs.TAB_CREATE || this.networkValid) {
            if (mouseX > 30 + this.field_147003_i && mouseX < 66 + this.field_147003_i && mouseY > 140 + this.field_147009_r && mouseY < 152 + this.field_147009_r) {
                if (this.delete.clickable) {
                    this.drawCenteredString(this.font, TextFormatting.BOLD + FluxTranslate.DELETE_NETWORK.t(), 48, 128, 0xFF0000);
                } else {
                    this.drawCenteredString(this.font, FluxTranslate.DOUBLE_SHIFT.t(), 48, 128, 0xFFFFFF);
                }
            }
            this.drawCenteredString(this.font, TextFormatting.RED + FluxNetworks.PROXY.getFeedback(false).getInfo(), 88, 156, 0xFFFFFF);
        } else {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.networkValid) {
            this.name.func_146180_a(this.network.getNetworkName());
            this.password.func_146180_a(this.network.getSetting(NetworkSettings.NETWORK_PASSWORD));
            this.password.func_146189_e(this.network.getSetting(NetworkSettings.NETWORK_SECURITY).isEncrypted());
            this.apply = new NormalButton(FluxTranslate.APPLY.t(), 112, 140, 36, 12, 3).setUnclickable();
            this.buttons.add(this.apply);
            this.delete = new NormalButton(FluxTranslate.DELETE.t(), 30, 140, 36, 12, 4).setUnclickable();
            this.buttons.add(this.delete);
            int i = 0;
            boolean colorSet = false;
            for (EnumNetworkColor color : EnumNetworkColor.values()) {
                ColorButton b2 = new ColorButton(48 + (i >= 7 ? i - 7 : i) * 16, 96 + (i >= 7 ? 1 : 0) * 16, color.color);
                this.colorButtons.add(b2);
                if (!colorSet && color.color == this.network.getSetting(NetworkSettings.NETWORK_COLOR)) {
                    this.color = b2;
                    this.color.selected = true;
                    colorSet = true;
                }
                ++i;
            }
            if (!colorSet) {
                ColorButton c = new ColorButton(32, 112, this.network.getSetting(NetworkSettings.NETWORK_COLOR));
                this.colorButtons.add(c);
                this.color = c;
                this.color.selected = true;
            }
        } else {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTabs.TAB_SELECTION.getTranslatedName(), b -> GuiTabSettings.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector));
            this.addButton((Widget)this.redirectButton);
        }
    }

    @Override
    public void onEditSettingsChanged() {
        if (this.networkValid && this.apply != null) {
            this.apply.clickable = (!this.securityType.isEncrypted() || this.password.func_146179_b().length() != 0) && this.name.func_146179_b().length() != 0;
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (this.networkValid && button instanceof NormalButton) {
            switch (button.id) {
                case 3: {
                    PacketHandler.INSTANCE.sendToServer((Object)new GeneralPacket(GeneralPacketEnum.EDIT_NETWORK, GeneralPacketHandler.getNetworkEditPacket(this.network.getNetworkID(), this.name.func_146179_b(), this.color.color, this.securityType, this.energyType, this.password.func_146179_b())));
                    break;
                }
                case 4: {
                    PacketHandler.INSTANCE.sendToServer((Object)new GeneralPacket(GeneralPacketEnum.DELETE_NETWORK, GeneralPacketHandler.getDeleteNetworkPacket(this.connector.getNetworkID())));
                }
            }
        }
    }

    @Override
    public boolean keyPressedMain(int keyCode, int scanCode, int modifiers) {
        if (this.delete != null) {
            if (scanCode == 42) {
                ++this.deleteCount;
                if (this.deleteCount > 1) {
                    this.delete.clickable = true;
                }
            } else {
                this.deleteCount = 0;
                this.delete.clickable = false;
            }
        }
        return super.keyPressedMain(keyCode, scanCode, modifiers);
    }

    @Override
    public void tick() {
        super.tick();
        if (FluxNetworks.PROXY.getFeedback(true) == EnumFeedbackInfo.SUCCESS) {
            GuiTabSettings.switchTab(EnumNavigationTabs.TAB_HOME, this.player, this.connector);
            FluxNetworks.PROXY.setFeedback(EnumFeedbackInfo.NONE, true);
        }
        if (FluxNetworks.PROXY.getFeedback(true) == EnumFeedbackInfo.SUCCESS_2) {
            this.apply.clickable = false;
            FluxNetworks.PROXY.setFeedback(EnumFeedbackInfo.NONE, true);
        }
    }
}

