/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumChargingTypes;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.InventoryButton;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.GeneralPacket;
import sonar.fluxnetworks.common.network.GeneralPacketEnum;
import sonar.fluxnetworks.common.network.GeneralPacketHandler;

public class GuiTabWireless
extends GuiTabCore {
    public InvisibleButton redirectButton;
    public List<InventoryButton> inventoryButtonList = new ArrayList<InventoryButton>();
    public NormalButton apply;
    public boolean[] settings = new boolean[EnumChargingTypes.values().length];

    public GuiTabWireless(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_WIRELESS;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.networkValid) {
            int colour = this.network.getSetting(NetworkSettings.NETWORK_COLOR);
            this.drawCenteredString(this.font, FluxTranslate.TAB_WIRELESS.t(), 88, 12, 0xB4B4B4);
            this.font.func_211126_b(FluxTranslate.ENABLE_WIRELESS.t(), 20.0f, 156.0f, colour);
            this.drawCenteredString(this.font, TextFormatting.RED + FluxNetworks.PROXY.getFeedback(false).getInfo(), 88, 146, 0xFFFFFF);
        } else {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void init() {
        super.init();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_WIRELESS, this.navigationTabs);
        this.inventoryButtonList.clear();
        this.buttonLists.add(this.inventoryButtonList);
        if (this.networkValid) {
            int setting = this.network.getSetting(NetworkSettings.NETWORK_WIRELESS);
            for (EnumChargingTypes types : EnumChargingTypes.values()) {
                this.settings[types.ordinal()] = types.isActivated(setting);
            }
            this.switches.add(new SlidedSwitchButton(140, 156, 4, this.field_147003_i, this.field_147009_r, this.settings[0]));
            this.inventoryButtonList.add(new InventoryButton(EnumChargingTypes.ARMOR_SLOT, this, 24, 32, 0, 80, 52, 16));
            this.inventoryButtonList.add(new InventoryButton(EnumChargingTypes.BAUBLES, this, 100, 32, 0, 80, 52, 16));
            this.inventoryButtonList.add(new InventoryButton(EnumChargingTypes.INVENTORY, this, 32, 56, 0, 0, 112, 40));
            this.inventoryButtonList.add(new InventoryButton(EnumChargingTypes.HOT_BAR, this, 32, 104, 112, 0, 112, 16));
            this.inventoryButtonList.add(new InventoryButton(EnumChargingTypes.RIGHT_HAND, this, 136, 128, 52, 80, 16, 16));
            this.inventoryButtonList.add(new InventoryButton(EnumChargingTypes.LEFT_HAND, this, 24, 128, 52, 80, 16, 16));
            this.apply = new NormalButton(FluxTranslate.APPLY.t(), 73, 130, 32, 12, 0).setUnclickable();
            this.buttons.add(this.apply);
        } else {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTabs.TAB_SELECTION.getTranslatedName(), b -> GuiTabWireless.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector));
            this.addButton((Widget)this.redirectButton);
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        if (button instanceof InventoryButton) {
            this.switchSetting(((InventoryButton)button).chargeType);
        }
        if (button instanceof NormalButton && button.id == 0) {
            int wireless = (this.settings[0] ? 1 : 0) | (this.settings[1] ? 1 : 0) << 1 | (this.settings[2] ? 1 : 0) << 2 | (this.settings[3] ? 1 : 0) << 3 | (this.settings[4] ? 1 : 0) << 4 | (this.settings[5] ? 1 : 0) << 5;
            PacketHandler.INSTANCE.sendToServer((Object)new GeneralPacket(GeneralPacketEnum.CHANGE_WIRELESS, GeneralPacketHandler.getChangeWirelessPacket(this.network.getNetworkID(), wireless)));
        }
        if (button instanceof SlidedSwitchButton) {
            ((SlidedSwitchButton)button).switchButton();
            if (((SlidedSwitchButton)button).id == 4) {
                this.switchSetting(EnumChargingTypes.ENABLE_WIRELESS);
            }
        }
    }

    public void switchSetting(EnumChargingTypes type) {
        this.settings[type.ordinal()] = !this.settings[type.ordinal()];
        this.apply.clickable = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.apply != null && FluxNetworks.PROXY.getFeedback(true) == EnumFeedbackInfo.SUCCESS) {
            this.apply.clickable = false;
            FluxNetworks.PROXY.setFeedback(EnumFeedbackInfo.NONE, true);
        }
    }
}

