/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.mui;

import icyllis.modernui.graphics.math.TextAlign;
import icyllis.modernui.gui.master.Canvas;
import icyllis.modernui.gui.master.IHost;
import icyllis.modernui.gui.master.IWidget;
import icyllis.modernui.gui.master.Icon;
import icyllis.modernui.gui.master.Locator;
import icyllis.modernui.gui.master.Module;
import icyllis.modernui.gui.master.Widget;
import icyllis.modernui.gui.math.Color3i;
import icyllis.modernui.gui.widget.SlidingToggleButton;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.api.gui.EnumChargingTypes;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.mui.NavigationHome;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.GeneralPacket;
import sonar.fluxnetworks.common.network.GeneralPacketEnum;
import sonar.fluxnetworks.common.network.GeneralPacketHandler;

public class WirelessCharging
extends Module {
    protected WirelessCharging() {
        this.addWireless(EnumChargingTypes.ARMOR_SLOT, 24.0f, 32.0f, 0.0f, 80.0f, 52.0f, 16.0f);
        this.addWireless(EnumChargingTypes.BAUBLES, 100.0f, 32.0f, 0.0f, 80.0f, 52.0f, 16.0f);
        this.addWireless(EnumChargingTypes.INVENTORY, 32.0f, 57.0f, 0.0f, 0.0f, 112.0f, 40.0f);
        this.addWireless(EnumChargingTypes.HOT_BAR, 32.0f, 106.0f, 112.0f, 0.0f, 112.0f, 16.0f);
        this.addWireless(EnumChargingTypes.LEFT_HAND, 24.0f, 131.0f, 52.0f, 80.0f, 16.0f, 16.0f);
        this.addWireless(EnumChargingTypes.RIGHT_HAND, 136.0f, 131.0f, 52.0f, 80.0f, 16.0f, 16.0f);
        this.addWidget((IWidget)new SlidingToggleButton.Builder(-2147038967, 0x40808080, 4).setLocator(new Locator(47.0f, 73.0f)).build((IHost)this).buildCallback(EnumChargingTypes.ENABLE_WIRELESS.isActivated(NavigationHome.network), b -> this.changeWireless(EnumChargingTypes.ENABLE_WIRELESS)));
    }

    private void addWireless(@Nonnull EnumChargingTypes type, float x, float y, float u, float v, float w, float h) {
        Icon icon = new Icon(ScreenUtils.INVENTORY, u / 256.0f, v / 256.0f, (u + w) / 256.0f, (v + h) / 256.0f, false);
        Widget.Builder builder = new Widget.Builder().setWidth(w).setHeight(h).setLocator(new Locator(x - 88.0f, y - 83.0f));
        this.addWidget((IWidget)new WirelessSlot((IHost)this, builder, icon, type));
    }

    private void changeWireless(@Nonnull EnumChargingTypes type) {
        int setting = NavigationHome.network.getSetting(NetworkSettings.NETWORK_WIRELESS);
        setting = type.isActivated(setting) ? (setting &= ~(1 << type.ordinal())) : (setting |= 1 << type.ordinal());
        PacketHandler.INSTANCE.sendToServer((Object)new GeneralPacket(GeneralPacketEnum.CHANGE_WIRELESS, GeneralPacketHandler.getChangeWirelessPacket(NavigationHome.network.getNetworkID(), setting)));
    }

    private class WirelessSlot
    extends Widget {
        private final Icon icon;
        private final String text;
        private final EnumChargingTypes type;

        public WirelessSlot(@Nonnull IHost host, @Nonnull Widget.Builder builder, @Nonnull Icon icon, EnumChargingTypes type) {
            super(host, builder);
            this.icon = icon;
            this.text = type.getTranslatedName();
            this.type = type;
        }

        protected void onDraw(@Nonnull Canvas canvas, float time) {
            int color = NavigationHome.network.getSetting(NetworkSettings.NETWORK_COLOR);
            float r = Color3i.getRedFrom((int)color);
            float g = Color3i.getGreenFrom((int)color);
            float b = Color3i.getBlueFrom((int)color);
            if (this.type.isActivated(NavigationHome.network)) {
                canvas.setRGBA(r, g, b, 1.0f);
            } else {
                canvas.setRGBA(r * 0.7f, g * 0.7f, b * 0.7f, 0.7f);
            }
            canvas.drawIcon(this.icon, this.x1, this.y1, this.x2, this.y2);
            if (this.isMouseHovered()) {
                canvas.setTextAlign(TextAlign.CENTER);
                canvas.resetColor();
                canvas.drawText(this.text, this.x1 + this.width / 2.0f, this.y1 - 9.0f);
            }
        }

        protected boolean onMouseLeftClick(double mouseX, double mouseY) {
            WirelessCharging.this.changeWireless(this.type);
            return true;
        }
    }
}

