/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.capability;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.management.OpEntry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.network.ISuperAdmin;
import sonar.fluxnetworks.api.utils.Capabilities;
import sonar.fluxnetworks.common.capability.SuperAdminStorage;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;

public class SuperAdminInstance
implements ISuperAdmin {
    public static final SuperAdminInstance DEFAULT = new SuperAdminInstance();
    private boolean superAdmin = false;

    @Override
    public void changePermission() {
        this.superAdmin = !this.superAdmin;
    }

    @Override
    public boolean hasPermission() {
        return this.superAdmin;
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT nbt) {
        nbt.func_74757_a("b", this.superAdmin);
        return nbt;
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT nbt) {
        this.superAdmin = nbt.func_74767_n("b");
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(ISuperAdmin.class, (Capability.IStorage)new SuperAdminStorage(), SuperAdminInstance::new);
    }

    public static boolean canActivateSuperAdmin(PlayerEntity player) {
        if (ServerLifecycleHooks.getCurrentServer().func_71264_H()) {
            return true;
        }
        OpEntry opEntry = (OpEntry)ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
        return opEntry != null && opEntry.func_152644_a() >= FluxConfig.superAdminRequiredPermission;
    }

    public static boolean isPlayerSuperAdmin(@Nonnull PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            return ((ISuperAdmin)player.getCapability(Capabilities.SUPER_ADMIN).orElse((Object)DEFAULT)).hasPermission();
        }
        return FluxNetworkCache.INSTANCE.superAdminClient;
    }
}

