/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import java.util.Iterator;
import java.util.List;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.common.connection.PriorityGroup;

public class TransferIterator<T extends IFluxConnector> {
    private Iterator<PriorityGroup<T>> groupIterator;
    private PriorityGroup<T> currentGroup;
    private Iterator<T> fluxIterator;
    private T currentFlux;
    private boolean isPoint;
    public boolean finish = false;

    public void reset(List<PriorityGroup<T>> list, boolean isPoint) {
        this.groupIterator = list.iterator();
        this.currentGroup = null;
        this.fluxIterator = null;
        this.currentFlux = null;
        this.isPoint = isPoint;
        this.finish = false;
        this.incrementGroup();
    }

    public boolean incrementGroup() {
        if (this.groupIterator.hasNext()) {
            this.currentGroup = this.groupIterator.next();
            this.fluxIterator = this.currentGroup.getConnectors().iterator();
            return this.incrementFlux();
        }
        this.finish = true;
        return false;
    }

    public boolean incrementFlux() {
        if (this.fluxIterator.hasNext()) {
            this.currentFlux = (IFluxConnector)this.fluxIterator.next();
            return this.needTransfer() || this.incrementFlux();
        }
        return this.incrementGroup();
    }

    public boolean needTransfer() {
        if (!this.currentFlux.isActive()) {
            return false;
        }
        if (this.isPoint) {
            return this.currentFlux.getTransferHandler().getRequest() > 0L;
        }
        return this.currentFlux.getTransferHandler().getBuffer() > 0L;
    }

    public T getCurrentFlux() {
        return this.currentFlux;
    }

    public boolean hasNext() {
        if (this.finish) {
            return false;
        }
        return this.needTransfer() || this.incrementFlux();
    }
}

