/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.transfer;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;
import sonar.fluxnetworks.api.network.IFluxTransfer;
import sonar.fluxnetworks.api.network.ISidedTransfer;
import sonar.fluxnetworks.common.core.FluxUtils;

public class ConnectionTransfer
implements IFluxTransfer,
ISidedTransfer {
    public final ITileEnergyHandler energyHandler;
    public final TileEntity tile;
    public final Direction dir;
    public final ItemStack displayStack;
    public long outbound;
    public long inbound;

    public ConnectionTransfer(ITileEnergyHandler energyHandler, TileEntity tile, Direction dir) {
        this.energyHandler = energyHandler;
        this.tile = tile;
        this.dir = dir;
        this.displayStack = FluxUtils.createItemStackFromBlock(tile.func_145831_w(), tile.func_174877_v());
    }

    @Override
    public long addEnergy(long amount, boolean simulate) {
        Direction dir = this.dir.func_176734_d();
        if (this.energyHandler.canAddEnergy(this.tile, dir)) {
            long added = this.energyHandler.addEnergy(amount, this.tile, dir, simulate);
            if (!simulate) {
                this.onEnergyAdded(added);
            }
            return added;
        }
        return 0L;
    }

    @Override
    public long removeEnergy(long amount, boolean simulate) {
        return 0L;
    }

    @Override
    public void onEnergyAdded(long amount) {
        this.inbound += amount;
    }

    @Override
    public void onEnergyRemoved(long amount) {
        this.outbound += amount;
    }

    @Override
    public void onStartCycle() {
        this.outbound = 0L;
        this.inbound = 0L;
    }

    @Override
    public void onEndCycle() {
    }

    @Override
    public TileEntity getTile() {
        return this.tile;
    }

    @Override
    public Direction getDir() {
        return this.dir;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    @Override
    public boolean isInvalid() {
        return this.tile.func_145837_r();
    }
}

