/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.translate.StyleUtils;
import sonar.fluxnetworks.api.utils.FluxConfigurationType;
import sonar.fluxnetworks.client.FluxColorHandler;
import sonar.fluxnetworks.common.core.ContainerConnector;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class FluxConfiguratorItem
extends Item {
    public FluxConfiguratorItem(Item.Properties props) {
        super(props);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        PlayerEntity player = context.func_195999_j();
        TileEntity tile = context.func_195991_k().func_175625_s(context.func_195995_a());
        if (tile instanceof TileFluxCore) {
            TileFluxCore fluxCore = (TileFluxCore)tile;
            if (!fluxCore.canAccess(context.func_195999_j())) {
                player.func_146105_b(StyleUtils.getErrorStyle(FluxTranslate.ACCESS_DENIED_KEY), true);
                return ActionResultType.FAIL;
            }
            ItemStack stack = player.func_184586_b(context.func_221531_n());
            if (player.func_225608_bj_()) {
                stack.func_77983_a("Configs", (INBT)fluxCore.copyConfiguration(new CompoundNBT()));
                player.func_145747_a((ITextComponent)new StringTextComponent("Copied Configuration"));
            } else {
                CompoundNBT configs = stack.func_190925_c("Configs");
                if (!configs.isEmpty()) {
                    fluxCore.pasteConfiguration(configs);
                    player.func_145747_a((ITextComponent)new StringTextComponent("Pasted Configuration"));
                }
            }
            return ActionResultType.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(player.func_184586_b(context.func_221531_n())), buf -> buf.writeBoolean(false));
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(player.func_184586_b(hand)), buf -> buf.writeBoolean(false));
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_179543_a("Configs");
        if (tag != null) {
            tooltip.add((ITextComponent)new StringTextComponent(FluxTranslate.NETWORK_FULL_NAME.t() + ": " + TextFormatting.WHITE + FluxColorHandler.getOrRequestNetworkName(tag.func_74762_e(FluxConfigurationType.NETWORK.getNBTName()))));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static class ContainerProvider
    implements INamedContainerProvider,
    INetworkConnector {
        public ItemStack stack;
        public int networkID;
        public IFluxNetwork network;

        public ContainerProvider(ItemStack stack) {
            this.stack = stack;
            CompoundNBT tag = stack.func_179543_a("Configs");
            this.networkID = tag != null ? tag.func_74762_e(FluxConfigurationType.NETWORK.getNBTName()) : -1;
            this.network = FluxNetworks.PROXY.getNetwork(this.networkID);
        }

        @Override
        public int getNetworkID() {
            return this.networkID;
        }

        @Override
        public IFluxNetwork getNetwork() {
            return this.network;
        }

        @Override
        public void open(PlayerEntity player) {
        }

        @Override
        public void close(PlayerEntity player) {
        }

        public ITextComponent func_145748_c_() {
            return this.stack.func_200301_q();
        }

        @Nullable
        public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity player) {
            return new ContainerConnector<ContainerProvider>(windowID, playerInventory, this);
        }
    }
}

