/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.api.utils.Coord4D;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.AbstractPacket;
import sonar.fluxnetworks.common.network.TilePacketEnum;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class TilePacket
extends AbstractPacket {
    private final TilePacketEnum type;
    private final CompoundNBT tag;
    private final Coord4D coord4D;

    public TilePacket(PacketBuffer buf) {
        this.coord4D = new Coord4D((ByteBuf)buf);
        this.type = TilePacketEnum.values()[buf.readInt()];
        this.tag = buf.func_150793_b();
    }

    public TilePacket(TilePacketEnum type, CompoundNBT tag, Coord4D coord4D) {
        this.type = type;
        this.tag = tag;
        this.coord4D = coord4D;
    }

    @Override
    public void encode(PacketBuffer buf) {
        this.coord4D.write((ByteBuf)buf);
        buf.writeInt(this.type.ordinal());
        buf.func_150786_a(this.tag);
    }

    @Override
    public Object handle(NetworkEvent.Context ctx) {
        PlayerEntity player = PacketHandler.getPlayer(ctx);
        if (player != null) {
            TileEntity tile;
            World world = player.func_130014_f_();
            if (world.func_201675_m().func_186058_p().func_186068_a() != this.coord4D.getDimension()) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                world = server.func_71218_a(DimensionType.func_186069_a((int)this.coord4D.getDimension()));
            }
            if ((tile = world.func_175625_s(this.coord4D.getPos())) instanceof TileFluxCore) {
                TileFluxCore flux = (TileFluxCore)tile;
                return this.type.handler.handlePacket(flux, player, this.tag);
            }
        }
        return null;
    }
}

